/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;

public class SetArchivingPlan
extends PhysicalPlan {
    private long taskId = -1L;
    private PartialPath storageGroup;
    private File targetDir;
    private long ttl;
    private long startTime;

    public SetArchivingPlan() {
        super(Operator.OperatorType.SET_ARCHIVING);
    }

    public SetArchivingPlan(PartialPath storageGroup, File targetDir, long ttl, long startTime) {
        super(Operator.OperatorType.SET_ARCHIVING);
        this.storageGroup = storageGroup;
        this.targetDir = targetDir;
        this.ttl = ttl;
        this.startTime = startTime;
    }

    public SetArchivingPlan(long taskId, PartialPath storageGroup, File targetDir, long ttl, long startTime) {
        super(Operator.OperatorType.SET_ARCHIVING);
        this.taskId = taskId;
        this.storageGroup = storageGroup;
        this.targetDir = targetDir;
        this.ttl = ttl;
        this.startTime = startTime;
    }

    public SetArchivingPlan(PartialPath storageGroup) {
        this(storageGroup, null, Long.MAX_VALUE, Long.MAX_VALUE);
    }

    public SetArchivingPlan(long taskId) {
        this(taskId, null, null, Long.MAX_VALUE, Long.MAX_VALUE);
    }

    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        int type = PhysicalPlan.PhysicalPlanType.ARCHIVING.ordinal();
        stream.writeByte((byte)type);
        stream.writeLong(this.ttl);
        stream.writeLong(this.startTime);
        this.putString(stream, this.storageGroup.getFullPath());
        this.putString(stream, this.targetDir.getAbsolutePath());
        stream.writeLong(this.taskId);
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.TTL.ordinal();
        buffer.put((byte)type);
        buffer.putLong(this.ttl);
        buffer.putLong(this.startTime);
        this.putString(buffer, this.storageGroup.getFullPath());
        this.putString(buffer, this.targetDir.getAbsolutePath());
        buffer.putLong(this.taskId);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.ttl = buffer.getLong();
        this.startTime = buffer.getLong();
        this.storageGroup = new PartialPath(this.readString(buffer));
        this.targetDir = new File(this.readString(buffer));
        this.taskId = buffer.getLong();
    }

    public long getTaskId() {
        return this.taskId;
    }

    public PartialPath getStorageGroup() {
        return this.storageGroup;
    }

    public void setStorageGroup(PartialPath storageGroup) {
        this.storageGroup = storageGroup;
    }

    public File getTargetDir() {
        return this.targetDir;
    }

    public void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    public long getTTL() {
        return this.ttl;
    }

    public void setTTL(long ttl) {
        this.ttl = ttl;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }
}

