/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.query.udf.api.UDTF;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.collector.PointCollector;
import org.apache.iotdb.db.query.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.db.query.udf.api.exception.UDFException;
import org.apache.iotdb.db.query.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class UDTFInRange
implements UDTF {
    protected TSDataType dataType;
    protected double upper;
    protected double lower;

    @Override
    public void validate(UDFParameterValidator validator) throws UDFException {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE).validateRequiredAttribute("upper").validateRequiredAttribute("lower").validate(args -> (Double)args[0] >= (Double)args[1], "Upper can not be smaller than lower.", validator.getParameters().getDouble("upper"), validator.getParameters().getDouble("lower"));
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws MetadataException {
        this.upper = parameters.getDouble("upper");
        this.lower = parameters.getDouble("lower");
        this.dataType = parameters.getDataType(0);
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(TSDataType.BOOLEAN);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws UDFInputSeriesDataTypeNotValidException, IOException {
        long time = row.getTime();
        switch (this.dataType) {
            case INT32: {
                collector.putBoolean(time, (double)row.getInt(0) >= this.lower && this.upper >= (double)row.getInt(0));
                break;
            }
            case INT64: {
                collector.putBoolean(time, (double)row.getLong(0) >= this.lower && this.upper >= (double)row.getLong(0));
                break;
            }
            case FLOAT: {
                collector.putBoolean(time, (double)row.getFloat(0) >= this.lower && this.upper >= (double)row.getFloat(0));
                break;
            }
            case DOUBLE: {
                collector.putBoolean(time, row.getDouble(0) >= this.lower && this.upper >= row.getDouble(0));
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, this.dataType, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
            }
        }
    }
}

