/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.utils;

import java.util.ArrayList;
import java.util.List;

public class StringContainer {
    private final String joinSeparator;
    private StringBuilder stringBuilder;
    private ArrayList<String> sequenceList = new ArrayList();
    private ArrayList<String> reverseList = new ArrayList();
    private int totalLength = 0;
    private int count = 0;
    private boolean isUpdated = true;
    private String cache;

    public StringContainer() {
        this.joinSeparator = null;
    }

    public StringContainer(String joinSeparator) {
        this.joinSeparator = joinSeparator;
    }

    public StringContainer(String[] strings) {
        this();
        this.addTail(strings);
    }

    public StringContainer(String[] strings, String joinSeparator) {
        this(joinSeparator);
        this.addTail(strings);
    }

    public int size() {
        return this.count;
    }

    public int length() {
        return this.totalLength;
    }

    public List<String> getSequenceList() {
        return this.sequenceList;
    }

    public List<String> getReverseList() {
        return this.reverseList;
    }

    public StringContainer addTail(Object ... objs) {
        this.isUpdated = true;
        this.count += objs.length;
        for (int i = 0; i < objs.length; ++i) {
            String str = objs[i].toString();
            this.totalLength += str.length();
            this.sequenceList.add(str);
        }
        return this;
    }

    public StringContainer addTail(String ... strings) {
        this.isUpdated = true;
        this.count += strings.length;
        for (int i = 0; i < strings.length; ++i) {
            this.totalLength += strings[i].length();
            this.sequenceList.add(strings[i]);
        }
        return this;
    }

    public StringContainer addTail(StringContainer myContainer) {
        String temp;
        int i;
        this.isUpdated = true;
        List<String> mySeqList = myContainer.getSequenceList();
        List<String> myRevList = myContainer.getReverseList();
        this.count += myRevList.size() + mySeqList.size();
        for (i = myRevList.size() - 1; i >= 0; --i) {
            temp = myRevList.get(i);
            this.sequenceList.add(temp);
            this.totalLength += temp.length();
        }
        for (i = 0; i < mySeqList.size(); ++i) {
            temp = mySeqList.get(i);
            this.sequenceList.add(temp);
            this.totalLength += temp.length();
        }
        return this;
    }

    public StringContainer addHead(String ... strings) {
        this.isUpdated = true;
        this.count += strings.length;
        for (int i = strings.length - 1; i >= 0; --i) {
            this.totalLength += strings[i].length();
            this.reverseList.add(strings[i]);
        }
        return this;
    }

    public StringContainer addHead(StringContainer myContainer) {
        String temp;
        int i;
        this.isUpdated = true;
        List<String> mySeqList = myContainer.getSequenceList();
        List<String> myRevList = myContainer.getReverseList();
        this.count += myRevList.size() + mySeqList.size();
        for (i = mySeqList.size() - 1; i >= 0; --i) {
            temp = mySeqList.get(i);
            this.reverseList.add(temp);
            this.totalLength += temp.length();
        }
        for (i = 0; i < myRevList.size(); ++i) {
            temp = myRevList.get(i);
            this.reverseList.add(temp);
            this.totalLength += temp.length();
        }
        return this;
    }

    public String toString() {
        if (!this.isUpdated) {
            return this.cache;
        }
        if (this.totalLength <= 0) {
            return "";
        }
        if (this.joinSeparator == null) {
            int i;
            this.stringBuilder = new StringBuilder(this.totalLength);
            for (i = this.reverseList.size() - 1; i >= 0; --i) {
                this.stringBuilder.append(this.reverseList.get(i));
            }
            for (i = 0; i < this.sequenceList.size(); ++i) {
                this.stringBuilder.append(this.sequenceList.get(i));
            }
            this.cache = this.stringBuilder.toString();
        } else {
            this.cache = this.join(this.joinSeparator);
        }
        this.isUpdated = false;
        return this.cache;
    }

    public String join(String separator) {
        int i;
        if (this.totalLength <= 0) {
            return "";
        }
        this.stringBuilder = new StringBuilder(this.totalLength + (this.count - 1) * separator.length());
        for (i = this.reverseList.size() - 1; i >= 1; --i) {
            this.stringBuilder.append(this.reverseList.get(i));
            this.stringBuilder.append(separator);
        }
        if (!this.reverseList.isEmpty()) {
            this.stringBuilder.append(this.reverseList.get(0));
            if (!this.sequenceList.isEmpty()) {
                this.stringBuilder.append(separator);
            }
        }
        for (i = 0; i < this.sequenceList.size() - 1; ++i) {
            this.stringBuilder.append(this.sequenceList.get(i));
            this.stringBuilder.append(separator);
        }
        if (!this.sequenceList.isEmpty()) {
            this.stringBuilder.append(this.sequenceList.get(i));
        }
        return this.stringBuilder.toString();
    }

    public String getSubString(int index) {
        int realIndex;
        int n = realIndex = index >= 0 ? index : this.count + index;
        if (realIndex < 0 || realIndex >= this.count) {
            throw new IndexOutOfBoundsException(String.format("Index: %d, Real Index: %d, Size: %d", index, realIndex, this.count));
        }
        if (realIndex < this.reverseList.size()) {
            return this.reverseList.get(this.reverseList.size() - 1 - realIndex);
        }
        return this.sequenceList.get(realIndex - this.reverseList.size());
    }

    public StringContainer getSubStringContainer(int start, int end) {
        int i;
        int realEndIndex;
        int realStartIndex = start >= 0 ? start : this.count + start;
        int n = realEndIndex = end >= 0 ? end : this.count + end;
        if (realStartIndex < 0 || realStartIndex >= this.count) {
            throw new IndexOutOfBoundsException(String.format("start Index: %d, Real start Index: %d, Size: %d", start, realStartIndex, this.count));
        }
        if (realEndIndex < 0 || realEndIndex >= this.count) {
            throw new IndexOutOfBoundsException(String.format("end Index: %d, Real end Index: %d, Size: %d", end, realEndIndex, this.count));
        }
        StringContainer ret = new StringContainer(this.joinSeparator);
        if (realStartIndex < this.reverseList.size()) {
            for (i = this.reverseList.size() - 1 - realStartIndex; i >= Math.max(0, this.reverseList.size() - 1 - realEndIndex); --i) {
                ret.addTail(this.reverseList.get(i));
            }
        }
        if (realEndIndex >= this.reverseList.size()) {
            for (i = Math.max(0, realStartIndex - this.reverseList.size()); i <= realEndIndex - this.reverseList.size(); ++i) {
                ret.addTail(this.sequenceList.get(i));
            }
        }
        return ret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.joinSeparator != null) {
            result = 31 * result + this.joinSeparator.hashCode();
        }
        for (String string : this.reverseList) {
            result = 31 * result + (string == null ? 0 : string.hashCode());
        }
        for (String string : this.sequenceList) {
            result = 31 * result + (string == null ? 0 : string.hashCode());
        }
        return result;
    }

    public boolean equals(Object sc) {
        if (sc == null) {
            return false;
        }
        if (this.getClass() != sc.getClass()) {
            return false;
        }
        return this.equals((StringContainer)sc);
    }

    public boolean equals(StringContainer sc) {
        int i;
        if (sc == this) {
            return true;
        }
        if (this.count != sc.count) {
            return false;
        }
        if (this.totalLength != sc.totalLength) {
            return false;
        }
        if (!this.joinSeparator.equals(sc.joinSeparator)) {
            return false;
        }
        if (this.sequenceList.size() != sc.sequenceList.size()) {
            return false;
        }
        for (i = 0; i < this.sequenceList.size(); ++i) {
            if (this.sequenceList.get(i).equals(sc.sequenceList.get(i))) continue;
            return false;
        }
        if (this.reverseList.size() != sc.reverseList.size()) {
            return false;
        }
        for (i = 0; i < this.reverseList.size(); ++i) {
            if (this.reverseList.get(i).equals(sc.reverseList.get(i))) continue;
            return false;
        }
        return true;
    }

    public StringContainer clone() {
        StringContainer ret = new StringContainer(this.joinSeparator);
        for (String s : this.sequenceList) {
            ret.sequenceList.add(s);
        }
        for (String s : this.reverseList) {
            ret.reverseList.add(s);
        }
        ret.totalLength = this.totalLength;
        ret.count = this.count;
        ret.isUpdated = this.isUpdated;
        ret.cache = this.cache;
        return ret;
    }
}

