/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.sink.payload;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeTransferFileSealReqV2;
import org.apache.iotdb.confignode.persistence.schema.CNSnapshotFileType;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;

public class PipeTransferConfigSnapshotSealReq
extends PipeTransferFileSealReqV2 {
    public static final String FILE_TYPE = "fileType";

    private PipeTransferConfigSnapshotSealReq() {
    }

    protected PipeRequestType getPlanType() {
        return PipeRequestType.TRANSFER_CONFIG_SNAPSHOT_SEAL;
    }

    public static PipeTransferConfigSnapshotSealReq toTPipeTransferReq(String treePattern, String tablePatternDatabase, String tablePatternTable, boolean isTreeCaptured, boolean isTableCaptured, String snapshotName, long snapshotLength, String templateFileName, long templateFileLength, CNSnapshotFileType fileType, String typeString) throws IOException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("PathPattern", treePattern);
        parameters.put("database_pattern", tablePatternDatabase);
        parameters.put("TableName", tablePatternTable);
        if (isTreeCaptured) {
            parameters.put("tree", "");
        }
        if (isTableCaptured) {
            parameters.put("table", "");
        }
        parameters.put(FILE_TYPE, Byte.toString(fileType.getType()));
        parameters.put("Type", typeString);
        return (PipeTransferConfigSnapshotSealReq)new PipeTransferConfigSnapshotSealReq().convertToTPipeTransferReq(Objects.nonNull(templateFileName) ? Arrays.asList(snapshotName, templateFileName) : Collections.singletonList(snapshotName), Objects.nonNull(templateFileName) ? Arrays.asList(snapshotLength, templateFileLength) : Collections.singletonList(snapshotLength), parameters);
    }

    public static PipeTransferConfigSnapshotSealReq fromTPipeTransferReq(TPipeTransferReq req) {
        return (PipeTransferConfigSnapshotSealReq)new PipeTransferConfigSnapshotSealReq().translateFromTPipeTransferReq(req);
    }

    public static byte[] toTPipeTransferBytes(String treePattern, String tablePatternDatabase, String tablePatternTable, boolean isTreeCaptured, boolean isTableCaptured, String snapshotName, long snapshotLength, String templateFileName, long templateFileLength, CNSnapshotFileType fileType, String typeString) throws IOException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("PathPattern", treePattern);
        parameters.put("database_pattern", tablePatternDatabase);
        parameters.put("TableName", tablePatternTable);
        if (isTreeCaptured) {
            parameters.put("tree", "");
        }
        if (isTableCaptured) {
            parameters.put("table", "");
        }
        parameters.put(FILE_TYPE, Byte.toString(fileType.getType()));
        parameters.put("Type", typeString);
        return new PipeTransferConfigSnapshotSealReq().convertToTPipeTransferSnapshotSealBytes(Objects.nonNull(templateFileName) ? Arrays.asList(snapshotName, templateFileName) : Collections.singletonList(snapshotName), Objects.nonNull(templateFileName) ? Arrays.asList(snapshotLength, templateFileLength) : Collections.singletonList(snapshotLength), parameters);
    }

    public boolean equals(Object obj) {
        return obj instanceof PipeTransferConfigSnapshotSealReq && super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

