/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.mqtt;

import io.moquette.interception.AbstractInterceptHandler;
import io.moquette.interception.messages.InterceptConnectMessage;
import io.moquette.interception.messages.InterceptDisconnectMessage;
import io.moquette.interception.messages.InterceptPublishMessage;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskExtractorRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.pipe.event.common.statement.PipeStatementInsertionEvent;
import org.apache.iotdb.db.protocol.mqtt.Message;
import org.apache.iotdb.db.protocol.mqtt.PayloadFormatManager;
import org.apache.iotdb.db.protocol.mqtt.PayloadFormatter;
import org.apache.iotdb.db.protocol.mqtt.TableMessage;
import org.apache.iotdb.db.protocol.mqtt.TreeMessage;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.protocol.session.MqttClientSession;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeDevicePathCache;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.service.rpc.thrift.TSProtocolVersion;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.BitMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTPublishHandler
extends AbstractInterceptHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MQTTPublishHandler.class);
    private final SessionManager sessionManager = SessionManager.getInstance();
    private final ConcurrentHashMap<String, MqttClientSession> clientIdToSessionMap = new ConcurrentHashMap();
    private final PayloadFormatter payloadFormat;
    private final boolean useTableInsert;
    private final UnboundedBlockingPendingQueue<EnrichedEvent> pendingQueue;
    private final String pipeName;
    private final long creationTime;
    private final PipeTaskMeta pipeTaskMeta;

    public MQTTPublishHandler(PipeParameters pipeParameters, PipeTaskExtractorRuntimeEnvironment environment, UnboundedBlockingPendingQueue<EnrichedEvent> pendingQueue) {
        this.payloadFormat = PayloadFormatManager.getPayloadFormat(pipeParameters.getStringOrDefault("mqtt.payload-formatter", "json"));
        this.useTableInsert = "table".equals(this.payloadFormat.getType());
        this.pipeName = environment.getPipeName();
        this.creationTime = environment.getCreationTime();
        this.pipeTaskMeta = environment.getPipeTaskMeta();
        this.pendingQueue = pendingQueue;
    }

    public String getID() {
        return "mqtt-source-broker-listener";
    }

    public void onConnect(InterceptConnectMessage msg) {
        if (!this.clientIdToSessionMap.containsKey(msg.getClientID())) {
            MqttClientSession session = new MqttClientSession(msg.getClientID());
            this.sessionManager.login(session, msg.getUsername(), new String(msg.getPassword()), ZoneId.systemDefault().toString(), TSProtocolVersion.IOTDB_SERVICE_PROTOCOL_V3, IoTDBConstant.ClientVersion.V_1_0, this.useTableInsert ? IClientSession.SqlDialect.TABLE : IClientSession.SqlDialect.TREE);
            this.sessionManager.registerSession(session);
            this.clientIdToSessionMap.put(msg.getClientID(), session);
        }
    }

    public void onDisconnect(InterceptDisconnectMessage msg) {
        MqttClientSession session = this.clientIdToSessionMap.remove(msg.getClientID());
        if (null != session) {
            this.sessionManager.removeCurrSession();
            this.sessionManager.closeSession(session, Coordinator.getInstance()::cleanupQueryExecution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPublish(InterceptPublishMessage msg) {
        try {
            List<Message> messages;
            String clientId = msg.getClientID();
            if (!this.clientIdToSessionMap.containsKey(clientId)) {
                return;
            }
            MqttClientSession session = this.clientIdToSessionMap.get(msg.getClientID());
            ByteBuf payload = msg.getPayload();
            String topic = msg.getTopicName();
            String username = msg.getUsername();
            MqttQoS qos = msg.getQos();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Receive publish message. clientId: {}, username: {}, qos: {}, topic: {}, payload: {}", new Object[]{clientId, username, qos, topic, payload});
            }
            if ((messages = this.payloadFormat.format(topic, payload)) == null) {
                return;
            }
            for (Message message : messages) {
                if (message == null) continue;
                if (this.useTableInsert) {
                    this.extractTable((TableMessage)message, session);
                    continue;
                }
                this.extractTree((TreeMessage)message, session);
            }
        }
        catch (Throwable t) {
            LOGGER.warn("onPublish execution exception, msg is {}, error is ", (Object)msg, (Object)t);
        }
        finally {
            super.onPublish(msg);
        }
    }

    private void extractTable(TableMessage message, MqttClientSession session) {
        try {
            TimestampPrecisionUtils.checkTimestampPrecision(message.getTimestamp());
            InsertTabletStatement insertTabletStatement = this.constructInsertTabletStatement(message);
            session.setSqlDialect(IClientSession.SqlDialect.TABLE);
            PipeStatementInsertionEvent event = new PipeStatementInsertionEvent(this.pipeName, this.creationTime, this.pipeTaskMeta, null, null, session.getUsername(), true, true, message.getDatabase(), insertTabletStatement);
            if (!event.increaseReferenceCount(MQTTPublishHandler.class.getName())) {
                LOGGER.warn("The reference count of the event {} cannot be increased, skipping it.", (Object)event);
                return;
            }
            this.pendingQueue.waitedOffer((Event)event);
        }
        catch (Exception e) {
            LOGGER.warn("meet error when polling mqtt source message database {}, table {}, tags {}, attributes {}, fields {}, at time {}, because {}", new Object[]{message.getDatabase(), message.getTable(), message.getTagKeys(), message.getAttributeKeys(), message.getFields(), message.getTimestamp(), e.getMessage(), e});
        }
    }

    private InsertTabletStatement constructInsertTabletStatement(TableMessage message) throws IllegalPathException {
        int i;
        InsertTabletStatement statement = new InsertTabletStatement();
        statement.setDevicePath(DataNodeDevicePathCache.getInstance().getPartialPath(message.getTable()));
        List<String> measurements = Stream.of(message.getFields(), message.getTagKeys(), message.getAttributeKeys()).flatMap(Collection::stream).collect(Collectors.toList());
        statement.setMeasurements(measurements.toArray(new String[0]));
        long[] timestamps = new long[]{message.getTimestamp()};
        statement.setTimes(timestamps);
        int columnSize = measurements.size();
        int rowSize = 1;
        BitMap[] bitMaps = new BitMap[columnSize];
        Object[] columns = Stream.of(message.getValues(), message.getTagValues(), message.getAttributeValues()).flatMap(Collection::stream).toArray(Object[]::new);
        statement.setColumns(columns);
        statement.setBitMaps(bitMaps);
        statement.setRowCount(rowSize);
        statement.setAligned(false);
        statement.setWriteToTable(true);
        TSDataType[] dataTypes = new TSDataType[measurements.size()];
        TsTableColumnCategory[] columnCategories = new TsTableColumnCategory[measurements.size()];
        for (i = 0; i < message.getFields().size(); ++i) {
            dataTypes[i] = message.getDataTypes().get(i);
            columnCategories[i] = TsTableColumnCategory.FIELD;
        }
        for (i = message.getFields().size(); i < message.getFields().size() + message.getTagKeys().size(); ++i) {
            dataTypes[i] = TSDataType.STRING;
            columnCategories[i] = TsTableColumnCategory.TAG;
        }
        for (i = message.getFields().size() + message.getTagKeys().size(); i < message.getFields().size() + message.getTagKeys().size() + message.getAttributeKeys().size(); ++i) {
            dataTypes[i] = TSDataType.STRING;
            columnCategories[i] = TsTableColumnCategory.ATTRIBUTE;
        }
        statement.setDataTypes(dataTypes);
        statement.setColumnCategories(columnCategories);
        return statement;
    }

    private void extractTree(TreeMessage message, MqttClientSession session) {
        try {
            InsertRowStatement statement = new InsertRowStatement();
            statement.setDevicePath(DataNodeDevicePathCache.getInstance().getPartialPath(message.getDevice()));
            TimestampPrecisionUtils.checkTimestampPrecision(message.getTimestamp());
            statement.setTime(message.getTimestamp());
            statement.setMeasurements(message.getMeasurements().toArray(new String[0]));
            if (message.getDataTypes() == null) {
                statement.setDataTypes(new TSDataType[message.getMeasurements().size()]);
                statement.setValues(message.getValues().toArray(new Object[0]));
                statement.setNeedInferType(true);
            } else {
                List<TSDataType> dataTypes = message.getDataTypes();
                List<String> values = message.getValues();
                Object[] inferredValues = new Object[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    inferredValues[i] = values.get(i) == null ? null : CommonUtils.parseValue(dataTypes.get(i), values.get(i));
                }
                statement.setDataTypes(dataTypes.toArray(new TSDataType[0]));
                statement.setValues(inferredValues);
            }
            statement.setAligned(false);
            PipeStatementInsertionEvent event = new PipeStatementInsertionEvent(this.pipeName, this.creationTime, this.pipeTaskMeta, null, null, session.getUsername(), true, false, message.getDevice(), statement);
            if (!event.increaseReferenceCount(MQTTPublishHandler.class.getName())) {
                LOGGER.warn("The reference count of the event {} cannot be increased, skipping it.", (Object)event);
                return;
            }
            this.pendingQueue.waitedOffer((Event)event);
        }
        catch (Exception e) {
            LOGGER.warn("meet error when polling mqtt source device {}, measurements {}, at time {}, because {}", new Object[]{message.getDevice(), message.getMeasurements(), message.getTimestamp(), e.getMessage(), e});
        }
    }

    public void onSessionLoopError(Throwable throwable) {
        LOGGER.warn("onSessionLoopError: {}", (Object)(throwable.getMessage() == null ? "null" : throwable.getMessage()), (Object)throwable);
    }
}

