/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mdn.fields;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;

public class Text {
    private final String content;

    public static Text fromRawText(String rawText) {
        Preconditions.checkNotNull(rawText);
        String trimmedText = rawText.trim();
        Preconditions.checkArgument(!trimmedText.isEmpty(), "Text should not be empty");
        return new Text(Text.replaceLineBreaksByContinuation(trimmedText));
    }

    private static String replaceLineBreaksByContinuation(String rawText) {
        return Joiner.on("\r\n ").join(Splitter.on("\n").trimResults().splitToList(rawText));
    }

    public Text(String content) {
        this.content = content;
    }

    public String formatted() {
        return this.content;
    }

    public final boolean equals(Object o) {
        if (o instanceof Text) {
            Text that = (Text)o;
            return Objects.equal(this.content, that.content);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.content);
    }
}

