/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.util;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;

public class CharsetUtil {
    public static final String CRLF = "\r\n";
    public static final int CR = 13;
    public static final int LF = 10;
    public static final int SP = 32;
    public static final int HT = 9;

    public static boolean isASCII(char ch) {
        return (0xFF80 & ch) == 0;
    }

    public static boolean isASCII(String s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("String may not be null");
        }
        int len = s2.length();
        for (int i = 0; i < len; ++i) {
            if (CharsetUtil.isASCII(s2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }

    public static boolean isWhitespace(String s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("String may not be null");
        }
        int len = s2.length();
        for (int i = 0; i < len; ++i) {
            if (CharsetUtil.isWhitespace(s2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Charset lookup(String name) {
        if (name == null) {
            return null;
        }
        try {
            return Charset.forName(name);
        }
        catch (IllegalCharsetNameException ex) {
            return null;
        }
        catch (UnsupportedCharsetException ex) {
            return null;
        }
    }
}

