/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.stream.Stream;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;

public final class DirectProcessor<T>
extends FluxProcessor<T, T> {
    private static final DirectInner[] EMPTY = new DirectInner[0];
    private static final DirectInner[] TERMINATED = new DirectInner[0];
    private volatile DirectInner<T>[] subscribers = EMPTY;
    private static final AtomicReferenceFieldUpdater<DirectProcessor, DirectInner[]> SUBSCRIBERS = AtomicReferenceFieldUpdater.newUpdater(DirectProcessor.class, DirectInner[].class, "subscribers");
    Throwable error;

    public static <E> DirectProcessor<E> create() {
        return new DirectProcessor();
    }

    DirectProcessor() {
    }

    @Override
    public int getPrefetch() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void onSubscribe(Subscription s2) {
        Objects.requireNonNull(s2, "s");
        if (this.subscribers != TERMINATED) {
            s2.request(Long.MAX_VALUE);
        } else {
            s2.cancel();
        }
    }

    @Override
    public void onNext(T t) {
        Objects.requireNonNull(t, "t");
        DirectInner<T>[] inners = this.subscribers;
        if (inners == TERMINATED) {
            Operators.onNextDropped(t, this.currentContext());
            return;
        }
        for (DirectInner<T> s2 : inners) {
            s2.onNext(t);
        }
    }

    @Override
    public void onError(Throwable t) {
        Objects.requireNonNull(t, "t");
        DirectInner<T>[] inners = this.subscribers;
        if (inners == TERMINATED) {
            Operators.onErrorDropped(t, this.currentContext());
            return;
        }
        this.error = t;
        for (DirectInner s2 : SUBSCRIBERS.getAndSet(this, TERMINATED)) {
            s2.onError(t);
        }
    }

    @Override
    public void onComplete() {
        for (DirectInner s2 : SUBSCRIBERS.getAndSet(this, TERMINATED)) {
            s2.onComplete();
        }
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Objects.requireNonNull(actual, "subscribe");
        DirectInner<? super T> p = new DirectInner<T>(actual, this);
        actual.onSubscribe(p);
        if (this.add(p)) {
            if (p.cancelled) {
                this.remove(p);
            }
        } else {
            Throwable e = this.error;
            if (e != null) {
                actual.onError(e);
            } else {
                actual.onComplete();
            }
        }
    }

    @Override
    public Stream<? extends Scannable> inners() {
        return Stream.of(this.subscribers);
    }

    @Override
    public boolean isTerminated() {
        return TERMINATED == this.subscribers;
    }

    @Override
    public long downstreamCount() {
        return this.subscribers.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean add(DirectInner<T> s2) {
        DirectInner<T>[] a = this.subscribers;
        if (a == TERMINATED) {
            return false;
        }
        DirectProcessor directProcessor = this;
        synchronized (directProcessor) {
            a = this.subscribers;
            if (a == TERMINATED) {
                return false;
            }
            int len = a.length;
            DirectInner[] b = new DirectInner[len + 1];
            System.arraycopy(a, 0, b, 0, len);
            b[len] = s2;
            this.subscribers = b;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(DirectInner<T> s2) {
        DirectInner<T>[] a = this.subscribers;
        if (a == TERMINATED || a == EMPTY) {
            return;
        }
        DirectProcessor directProcessor = this;
        synchronized (directProcessor) {
            a = this.subscribers;
            if (a == TERMINATED || a == EMPTY) {
                return;
            }
            int len = a.length;
            int j = -1;
            for (int i = 0; i < len; ++i) {
                if (a[i] != s2) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (len == 1) {
                this.subscribers = EMPTY;
                return;
            }
            DirectInner[] b = new DirectInner[len - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, len - j - 1);
            this.subscribers = b;
        }
    }

    @Override
    public boolean hasDownstreams() {
        DirectInner<T>[] s2 = this.subscribers;
        return s2 != EMPTY && s2 != TERMINATED;
    }

    @Override
    @Nullable
    public Throwable getError() {
        if (this.subscribers == TERMINATED) {
            return this.error;
        }
        return null;
    }

    static final class DirectInner<T>
    implements InnerProducer<T> {
        final CoreSubscriber<? super T> actual;
        final DirectProcessor<T> parent;
        volatile boolean cancelled;
        volatile long requested;
        static final AtomicLongFieldUpdater<DirectInner> REQUESTED = AtomicLongFieldUpdater.newUpdater(DirectInner.class, "requested");

        DirectInner(CoreSubscriber<? super T> actual, DirectProcessor<T> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        @Override
        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.addCap(REQUESTED, this, n);
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.parent.remove(this);
            }
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.parent;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.cancelled;
            }
            return InnerProducer.super.scanUnsafe(key);
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        void onNext(T value) {
            if (this.requested != 0L) {
                this.actual.onNext(value);
                if (this.requested != Long.MAX_VALUE) {
                    REQUESTED.decrementAndGet(this);
                }
                return;
            }
            this.parent.remove(this);
            this.actual.onError(Exceptions.failWithOverflow("Can't deliver value due to lack of requests"));
        }

        void onError(Throwable e) {
            this.actual.onError(e);
        }

        void onComplete() {
            this.actual.onComplete();
        }
    }
}

