/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import java.time.Clock;
import java.time.Instant;
import javax.inject.Inject;
import org.apache.james.queue.rabbitmq.EnqueuedItem;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.view.cassandra.BrowseStartDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.ContentStartDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.EnqueuedMailsDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.CassandraMailQueueViewConfiguration;
import org.apache.james.queue.rabbitmq.view.cassandra.model.BucketedSlices;
import org.apache.james.queue.rabbitmq.view.cassandra.model.EnqueuedItemWithSlicingContext;
import org.apache.mailet.Mail;
import reactor.core.publisher.Mono;

public class CassandraMailQueueMailStore {
    private final EnqueuedMailsDAO enqueuedMailsDao;
    private final BrowseStartDAO browseStartDao;
    private final ContentStartDAO contentStartDAO;
    private final CassandraMailQueueViewConfiguration configuration;
    private final Clock clock;

    @Inject
    CassandraMailQueueMailStore(EnqueuedMailsDAO enqueuedMailsDao, BrowseStartDAO browseStartDao, ContentStartDAO contentStartDAO, CassandraMailQueueViewConfiguration configuration, Clock clock) {
        this.enqueuedMailsDao = enqueuedMailsDao;
        this.browseStartDao = browseStartDao;
        this.contentStartDAO = contentStartDAO;
        this.configuration = configuration;
        this.clock = clock;
    }

    Mono<Void> storeMail(EnqueuedItem enqueuedItem) {
        EnqueuedItemWithSlicingContext enqueuedItemAndSlicing = this.addSliceContext(enqueuedItem);
        return this.enqueuedMailsDao.insert(enqueuedItemAndSlicing);
    }

    Mono<Void> initializeBrowseStart(MailQueueName mailQueueName) {
        return this.browseStartDao.insertInitialBrowseStart(mailQueueName, this.currentSliceStartInstant());
    }

    Mono<Void> initializeContentStart(MailQueueName mailQueueName) {
        return this.browseStartDao.findBrowseStart(mailQueueName).flatMap(browseStart -> this.contentStartDAO.insertInitialContentStart(mailQueueName, (Instant)browseStart));
    }

    private EnqueuedItemWithSlicingContext addSliceContext(EnqueuedItem enqueuedItem) {
        Mail mail = enqueuedItem.getMail();
        return EnqueuedItemWithSlicingContext.builder().enqueuedItem(enqueuedItem).slicingContext(EnqueuedItemWithSlicingContext.SlicingContext.of(this.computedBucketId(mail), this.currentSliceStartInstant())).build();
    }

    private Instant currentSliceStartInstant() {
        long sliceSize = this.configuration.getSliceWindow().getSeconds();
        long sliceId = this.clock.instant().getEpochSecond() / sliceSize;
        return Instant.ofEpochSecond(sliceId * sliceSize);
    }

    private BucketedSlices.BucketId computedBucketId(Mail mail) {
        return BucketedSlices.BucketId.of(mail.getName(), this.configuration.getBucketCount());
    }
}

