/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.CertificateDataReplaceCertificateKeyStoreContent;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.KeyStoreDataReplaceCertificateKeyStoreContent;
import com.unboundid.ldap.sdk.unboundidds.extensions.KeyStoreFileReplaceCertificateKeyStoreContent;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class ReplaceCertificateKeyStoreContent
implements Serializable {
    private static final long serialVersionUID = 352192622190846396L;

    @NotNull
    public abstract ASN1Element encode();

    @NotNull
    public static ReplaceCertificateKeyStoreContent decode(@NotNull ASN1Element element) throws LDAPException {
        switch (element.getType()) {
            case -96: {
                return KeyStoreFileReplaceCertificateKeyStoreContent.decodeInternal(element);
            }
            case -95: {
                return KeyStoreDataReplaceCertificateKeyStoreContent.decodeInternal(element);
            }
            case -94: {
                return CertificateDataReplaceCertificateKeyStoreContent.decodeInternal(element);
            }
        }
        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_KSC_DECODE_UNRECOGNIZED_TYPE.get(StaticUtils.toHex(element.getType())));
    }

    @NotNull
    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(@NotNull StringBuilder var1);
}

