/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.ResultCodeInfo;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class OperationResultCodeInfo
implements Serializable {
    private static final long serialVersionUID = 4688688688915878084L;
    @Nullable
    private final Double failedPercent;
    @Nullable
    private final Long failedCount;
    @Nullable
    private final Long totalCount;
    @NotNull
    private final Map<Integer, ResultCodeInfo> resultCodeInfoMap;
    @Nullable
    private final OperationType operationType;

    OperationResultCodeInfo(@NotNull MonitorEntry entry, @Nullable OperationType operationType, @NotNull String opTypeAttrPrefix) {
        this.operationType = operationType;
        this.totalCount = entry.getLong(opTypeAttrPrefix + "total-count");
        this.failedCount = entry.getLong(opTypeAttrPrefix + "failed-count");
        this.failedPercent = entry.getDouble(opTypeAttrPrefix + "failed-percent");
        String rcPrefix = opTypeAttrPrefix + "result-";
        TreeMap<Integer, ResultCodeInfo> rcMap = new TreeMap<Integer, ResultCodeInfo>();
        ReadOnlyEntry e = entry.getEntry();
        for (Attribute a : e.getAttributes()) {
            try {
                String lowerName = StaticUtils.toLowerCase(a.getName());
                if (!lowerName.startsWith(rcPrefix) || !lowerName.endsWith("-name")) continue;
                String name = a.getValue();
                int intValue = Integer.parseInt(lowerName.substring(rcPrefix.length(), lowerName.length() - 5));
                long count = entry.getLong(rcPrefix + intValue + "-count");
                double percent = entry.getDouble(rcPrefix + intValue + "-percent");
                double totalResponseTimeMillis = entry.getDouble(rcPrefix + intValue + "-total-response-time-millis");
                double averageResponseTimeMillis = entry.getDouble(rcPrefix + intValue + "-average-response-time-millis");
                rcMap.put(intValue, new ResultCodeInfo(intValue, name, operationType, count, percent, totalResponseTimeMillis, averageResponseTimeMillis));
            }
            catch (Exception ex) {
                Debug.debugException(ex);
            }
        }
        this.resultCodeInfoMap = Collections.unmodifiableMap(rcMap);
    }

    @Nullable
    public OperationType getOperationType() {
        return this.operationType;
    }

    @Nullable
    public Long getTotalCount() {
        return this.totalCount;
    }

    @Nullable
    public Long getFailedCount() {
        return this.failedCount;
    }

    @Nullable
    public Double getFailedPercent() {
        return this.failedPercent;
    }

    @NotNull
    public Map<Integer, ResultCodeInfo> getResultCodeInfoMap() {
        return this.resultCodeInfoMap;
    }
}

