/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.AbstractConnectionPool;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.controls.DraftLDUPSubentriesRequestControl;
import com.unboundid.ldap.sdk.controls.ManageDsaITRequestControl;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.ldap.sdk.extensions.WhoAmIExtendedRequest;
import com.unboundid.ldap.sdk.extensions.WhoAmIExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.controls.HardDeleteRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PermitUnindexedSearchRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.ReturnConflictEntriesRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.SoftDeletedEntryAccessRequestControl;
import com.unboundid.ldap.sdk.unboundidds.extensions.SetSubtreeAccessibilityExtendedRequest;
import com.unboundid.util.Debug;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.SubtreeDeleterResult;
import com.unboundid.util.SubtreeDeleterSearchResultListener;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class SubtreeDeleter {
    private boolean deleteBaseEntry = true;
    private boolean useHardDeleteControlIfAvailable = true;
    private boolean useManageDSAITControlIfAvailable = true;
    private boolean usePermitUnindexedSearchControlIfAvailable = false;
    private boolean useReturnConflictEntriesRequestControlIfAvailable = true;
    private boolean useSimplePagedResultsControlIfAvailable = true;
    private boolean useSoftDeletedEntryAccessControlIfAvailable = true;
    private boolean useSubentriesControlIfAvailable = true;
    private boolean useSetSubtreeAccessibilityOperationIfAvailable = false;
    private int searchRequestSizeLimit = 0;
    private int simplePagedResultsPageSize = 100;
    @Nullable
    private FixedRateBarrier deleteRateLimiter = null;
    @NotNull
    private List<Control> additionalSearchControls = Collections.emptyList();
    @NotNull
    private List<Control> additionalDeleteControls = Collections.emptyList();

    public boolean deleteBaseEntry() {
        return this.deleteBaseEntry;
    }

    public void setDeleteBaseEntry(boolean deleteBaseEntry) {
        this.deleteBaseEntry = deleteBaseEntry;
    }

    public boolean useSetSubtreeAccessibilityOperationIfAvailable() {
        return this.useSetSubtreeAccessibilityOperationIfAvailable;
    }

    public void setUseSetSubtreeAccessibilityOperationIfAvailable(boolean useSetSubtreeAccessibilityOperationIfAvailable) {
        this.useSetSubtreeAccessibilityOperationIfAvailable = useSetSubtreeAccessibilityOperationIfAvailable;
    }

    public boolean useSimplePagedResultsControlIfAvailable() {
        return this.useSimplePagedResultsControlIfAvailable;
    }

    public void setUseSimplePagedResultsControlIfAvailable(boolean useSimplePagedResultsControlIfAvailable) {
        this.useSimplePagedResultsControlIfAvailable = useSimplePagedResultsControlIfAvailable;
    }

    public int getSimplePagedResultsPageSize() {
        return this.simplePagedResultsPageSize;
    }

    public void setSimplePagedResultsPageSize(int simplePagedResultsPageSize) {
        Validator.ensureTrue(simplePagedResultsPageSize >= 1, "SubtreeDeleter.simplePagedResultsPageSize must be greater than or equal to 1.");
        this.simplePagedResultsPageSize = simplePagedResultsPageSize;
    }

    public boolean useManageDSAITControlIfAvailable() {
        return this.useManageDSAITControlIfAvailable;
    }

    public void setUseManageDSAITControlIfAvailable(boolean useManageDSAITControlIfAvailable) {
        this.useManageDSAITControlIfAvailable = useManageDSAITControlIfAvailable;
    }

    public boolean usePermitUnindexedSearchControlIfAvailable() {
        return this.usePermitUnindexedSearchControlIfAvailable;
    }

    public void setUsePermitUnindexedSearchControlIfAvailable(boolean usePermitUnindexedSearchControlIfAvailable) {
        this.usePermitUnindexedSearchControlIfAvailable = usePermitUnindexedSearchControlIfAvailable;
    }

    public boolean useSubentriesControlIfAvailable() {
        return this.useSubentriesControlIfAvailable;
    }

    public void setUseSubentriesControlIfAvailable(boolean useSubentriesControlIfAvailable) {
        this.useSubentriesControlIfAvailable = useSubentriesControlIfAvailable;
    }

    public boolean useReturnConflictEntriesRequestControlIfAvailable() {
        return this.useReturnConflictEntriesRequestControlIfAvailable;
    }

    public void setUseReturnConflictEntriesRequestControlIfAvailable(boolean useReturnConflictEntriesRequestControlIfAvailable) {
        this.useReturnConflictEntriesRequestControlIfAvailable = useReturnConflictEntriesRequestControlIfAvailable;
    }

    public boolean useSoftDeletedEntryAccessControlIfAvailable() {
        return this.useSoftDeletedEntryAccessControlIfAvailable;
    }

    public void setUseSoftDeletedEntryAccessControlIfAvailable(boolean useSoftDeletedEntryAccessControlIfAvailable) {
        this.useSoftDeletedEntryAccessControlIfAvailable = useSoftDeletedEntryAccessControlIfAvailable;
    }

    public boolean useHardDeleteControlIfAvailable() {
        return this.useHardDeleteControlIfAvailable;
    }

    public void setUseHardDeleteControlIfAvailable(boolean useHardDeleteControlIfAvailable) {
        this.useHardDeleteControlIfAvailable = useHardDeleteControlIfAvailable;
    }

    @NotNull
    public List<Control> getAdditionalSearchControls() {
        return this.additionalSearchControls;
    }

    public void setAdditionalSearchControls(Control ... additionalSearchControls) {
        this.setAdditionalSearchControls(Arrays.asList(additionalSearchControls));
    }

    public void setAdditionalSearchControls(@NotNull List<Control> additionalSearchControls) {
        this.additionalSearchControls = Collections.unmodifiableList(new ArrayList<Control>(additionalSearchControls));
    }

    @NotNull
    public List<Control> getAdditionalDeleteControls() {
        return this.additionalDeleteControls;
    }

    public void setAdditionalDeleteControls(Control ... additionalDeleteControls) {
        this.setAdditionalDeleteControls(Arrays.asList(additionalDeleteControls));
    }

    public void setAdditionalDeleteControls(@NotNull List<Control> additionalDeleteControls) {
        this.additionalDeleteControls = Collections.unmodifiableList(new ArrayList<Control>(additionalDeleteControls));
    }

    public int getSearchRequestSizeLimit() {
        return this.searchRequestSizeLimit;
    }

    public void setSearchRequestSizeLimit(int searchRequestSizeLimit) {
        this.searchRequestSizeLimit = searchRequestSizeLimit <= 0 ? 0 : searchRequestSizeLimit;
    }

    @Nullable
    public FixedRateBarrier getDeleteRateLimiter() {
        return this.deleteRateLimiter;
    }

    public void setDeleteRateLimiter(@Nullable FixedRateBarrier deleteRateLimiter) {
        this.deleteRateLimiter = deleteRateLimiter;
    }

    @NotNull
    public SubtreeDeleterResult delete(@NotNull LDAPInterface connection, @NotNull String baseDN) throws LDAPException {
        return this.delete(connection, new DN(baseDN));
    }

    @NotNull
    public SubtreeDeleterResult delete(@NotNull LDAPInterface connection, @NotNull DN baseDN) {
        AtomicReference<RootDSE> rootDSE = new AtomicReference<RootDSE>();
        boolean useSetSubtreeAccessibility = this.useSetSubtreeAccessibilityOperationIfAvailable && SubtreeDeleter.supportsExtendedRequest(connection, rootDSE, "1.3.6.1.4.1.30221.2.6.19") && SubtreeDeleter.supportsExtendedRequest(connection, rootDSE, "1.3.6.1.4.1.4203.1.11.3");
        boolean usePagedResults = this.useSimplePagedResultsControlIfAvailable && SubtreeDeleter.supportsControl(connection, rootDSE, "1.2.840.113556.1.4.319");
        boolean useSubentries = this.useSubentriesControlIfAvailable && SubtreeDeleter.supportsControl(connection, rootDSE, "1.3.6.1.4.1.7628.5.101.1");
        ArrayList<Control> searchControls = new ArrayList<Control>(10);
        searchControls.addAll(this.additionalSearchControls);
        ArrayList<Control> deleteControls = new ArrayList<Control>(10);
        deleteControls.addAll(this.additionalDeleteControls);
        if (this.useHardDeleteControlIfAvailable && SubtreeDeleter.supportsControl(connection, rootDSE, "1.3.6.1.4.1.30221.2.5.22")) {
            deleteControls.add(new HardDeleteRequestControl(false));
        }
        if (this.useManageDSAITControlIfAvailable && SubtreeDeleter.supportsControl(connection, rootDSE, "2.16.840.1.113730.3.4.2")) {
            ManageDsaITRequestControl c = new ManageDsaITRequestControl(false);
            searchControls.add(c);
            deleteControls.add(c);
        }
        if (this.usePermitUnindexedSearchControlIfAvailable && SubtreeDeleter.supportsControl(connection, rootDSE, "1.3.6.1.4.1.30221.2.5.55")) {
            searchControls.add(new PermitUnindexedSearchRequestControl(false));
        }
        if (this.useReturnConflictEntriesRequestControlIfAvailable && SubtreeDeleter.supportsControl(connection, rootDSE, "1.3.6.1.4.1.30221.2.5.13")) {
            searchControls.add(new ReturnConflictEntriesRequestControl(false));
        }
        if (this.useSoftDeletedEntryAccessControlIfAvailable && SubtreeDeleter.supportsControl(connection, rootDSE, "1.3.6.1.4.1.30221.2.5.24")) {
            searchControls.add(new SoftDeletedEntryAccessRequestControl(false, true, false));
        }
        return SubtreeDeleter.delete(connection, baseDN, this.deleteBaseEntry, useSetSubtreeAccessibility, usePagedResults, this.searchRequestSizeLimit, this.simplePagedResultsPageSize, useSubentries, searchControls, deleteControls, this.deleteRateLimiter);
    }

    @NotNull
    private static SubtreeDeleterResult delete(@NotNull LDAPInterface connection, @NotNull DN baseDN, boolean deleteBaseEntry, boolean useSetSubtreeAccessibilityOperation, boolean useSimplePagedResultsControl, int searchRequestSizeLimit, int pageSize, boolean useSubentriesControl, @NotNull List<Control> searchControls, @NotNull List<Control> deleteControls, @Nullable FixedRateBarrier deleteRateLimiter) {
        ExtendedResult setInaccessibleResult;
        if (useSetSubtreeAccessibilityOperation && (setInaccessibleResult = SubtreeDeleter.setInaccessible(connection, baseDN)) != null) {
            return new SubtreeDeleterResult(setInaccessibleResult, false, null, 0L, new TreeMap<DN, LDAPResult>());
        }
        SubtreeDeleterResult result = useSimplePagedResultsControl ? SubtreeDeleter.deleteEntriesWithSimplePagedResults(connection, baseDN, deleteBaseEntry, searchRequestSizeLimit, pageSize, useSubentriesControl, searchControls, deleteControls, deleteRateLimiter) : SubtreeDeleter.deleteEntriesWithoutSimplePagedResults(connection, baseDN, deleteBaseEntry, searchRequestSizeLimit, useSubentriesControl, searchControls, deleteControls, deleteRateLimiter);
        if (result.completelySuccessful() && useSetSubtreeAccessibilityOperation) {
            ExtendedResult removeAccessibilityRestrictionResult = SubtreeDeleter.removeAccessibilityRestriction(connection, baseDN);
            if (removeAccessibilityRestrictionResult.getResultCode() == ResultCode.SUCCESS) {
                return new SubtreeDeleterResult(null, false, null, result.getEntriesDeleted(), result.getDeleteErrorsTreeMap());
            }
            return new SubtreeDeleterResult(removeAccessibilityRestrictionResult, true, null, result.getEntriesDeleted(), result.getDeleteErrorsTreeMap());
        }
        return new SubtreeDeleterResult(null, useSetSubtreeAccessibilityOperation, result.getSearchError(), result.getEntriesDeleted(), result.getDeleteErrorsTreeMap());
    }

    @Nullable
    private static ExtendedResult setInaccessible(@NotNull LDAPInterface connection, @NotNull DN baseDN) {
        ExtendedResult genericWhoAmIResult = SubtreeDeleter.processExtendedOperation(connection, new WhoAmIExtendedRequest());
        if (genericWhoAmIResult.getResultCode() != ResultCode.SUCCESS) {
            return genericWhoAmIResult;
        }
        WhoAmIExtendedResult whoAmIResult = (WhoAmIExtendedResult)genericWhoAmIResult;
        String authzID = whoAmIResult.getAuthorizationID();
        if (!authzID.startsWith("dn:")) {
            return new ExtendedResult(-1, ResultCode.LOCAL_ERROR, UtilityMessages.ERR_SUBTREE_DELETER_INTERFACE_WHO_AM_I_AUTHZ_ID_NOT_DN.get(authzID), null, StaticUtils.NO_STRINGS, null, null, StaticUtils.NO_CONTROLS);
        }
        String authzDN = authzID.substring(3);
        ExtendedResult setInaccessibleResult = SubtreeDeleter.processExtendedOperation(connection, SetSubtreeAccessibilityExtendedRequest.createSetHiddenRequest(baseDN.toString(), authzDN, new Control[0]));
        if (setInaccessibleResult.getResultCode() == ResultCode.SUCCESS) {
            return null;
        }
        return setInaccessibleResult;
    }

    @NotNull
    private static SubtreeDeleterResult deleteEntriesWithSimplePagedResults(@NotNull LDAPInterface connection, @NotNull DN baseDN, boolean deleteBaseEntry, int searchRequestSizeLimit, int pageSize, boolean useSubentriesControl, @NotNull List<Control> searchControls, @NotNull List<Control> deleteControls, @Nullable FixedRateBarrier deleteRateLimiter) {
        SearchRequest searchRequest;
        TreeSet<DN> dnsToDelete = new TreeSet<DN>();
        if (useSubentriesControl) {
            try {
                searchRequest = SubtreeDeleter.createSubentriesSearchRequest(baseDN, 0, searchControls, dnsToDelete);
                SubtreeDeleter.doPagedResultsSearch(connection, searchRequest, pageSize);
            }
            catch (LDAPSearchException e) {
                Debug.debugException(e);
                return new SubtreeDeleterResult(null, false, e.getSearchResult(), 0L, new TreeMap<DN, LDAPResult>());
            }
        }
        try {
            searchRequest = SubtreeDeleter.createNonSubentriesSearchRequest(baseDN, 0, searchControls, dnsToDelete);
            SubtreeDeleter.doPagedResultsSearch(connection, searchRequest, pageSize);
        }
        catch (LDAPSearchException e) {
            Debug.debugException(e);
            return new SubtreeDeleterResult(null, false, e.getSearchResult(), 0L, new TreeMap<DN, LDAPResult>());
        }
        if (!deleteBaseEntry) {
            dnsToDelete.remove(baseDN);
        }
        AtomicReference<SearchResult> searchError = new AtomicReference<SearchResult>();
        AtomicLong entriesDeleted = new AtomicLong(0L);
        TreeMap<DN, LDAPResult> deleteErrors = new TreeMap<DN, LDAPResult>();
        Iterator<DN> iterator = dnsToDelete.descendingIterator();
        while (iterator.hasNext()) {
            DN dn = iterator.next();
            if (deleteErrors.containsKey(dn) || SubtreeDeleter.deleteEntry(connection, dn, deleteControls, entriesDeleted, deleteErrors, deleteRateLimiter, searchRequestSizeLimit, searchControls, useSubentriesControl, searchError)) continue;
            for (DN parentDN = dn.getParent(); parentDN != null && parentDN.isDescendantOf(baseDN, true) && !deleteErrors.containsKey(parentDN); parentDN = parentDN.getParent()) {
                deleteErrors.put(parentDN, new LDAPResult(-1, ResultCode.NOT_ALLOWED_ON_NONLEAF, UtilityMessages.ERR_SUBTREE_DELETER_SKIPPING_UNDELETABLE_ANCESTOR.get(String.valueOf(parentDN), String.valueOf(dn)), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS));
            }
        }
        return new SubtreeDeleterResult(null, false, null, entriesDeleted.get(), deleteErrors);
    }

    @NotNull
    private static SearchRequest createSubentriesSearchRequest(@NotNull DN baseDN, int searchRequestSizeLimit, @NotNull List<Control> controls, @NotNull SortedSet<DN> dnSet) {
        Filter filter = Filter.createEqualityFilter("objectClass", "ldapSubentry");
        SubtreeDeleterSearchResultListener searchListener = new SubtreeDeleterSearchResultListener(baseDN, filter, dnSet);
        SearchRequest searchRequest = new SearchRequest((SearchResultListener)searchListener, baseDN.toString(), SearchScope.SUB, DereferencePolicy.NEVER, searchRequestSizeLimit, 0, false, filter, "1.1");
        for (Control c : controls) {
            searchRequest.addControl(c);
        }
        searchRequest.addControl(new DraftLDUPSubentriesRequestControl(false));
        return searchRequest;
    }

    @NotNull
    private static SearchRequest createNonSubentriesSearchRequest(@NotNull DN baseDN, int searchRequestSizeLimit, @NotNull List<Control> controls, @NotNull SortedSet<DN> dnSet) {
        Filter filter = Filter.createPresenceFilter("objectClass");
        SubtreeDeleterSearchResultListener searchListener = new SubtreeDeleterSearchResultListener(baseDN, filter, dnSet);
        SearchRequest searchRequest = new SearchRequest((SearchResultListener)searchListener, baseDN.toString(), SearchScope.SUB, DereferencePolicy.NEVER, searchRequestSizeLimit, 0, false, filter, "1.1");
        for (Control c : controls) {
            searchRequest.addControl(c);
        }
        return searchRequest;
    }

    private static void doPagedResultsSearch(@NotNull LDAPInterface connection, @NotNull SearchRequest searchRequest, int pageSize) throws LDAPSearchException {
        SubtreeDeleterSearchResultListener searchListener = (SubtreeDeleterSearchResultListener)searchRequest.getSearchResultListener();
        ASN1OctetString pagedResultsCookie = null;
        while (true) {
            SimplePagedResultsControl responseControl;
            SearchResult searchResult;
            SearchRequest pagedResultsSearchRequest = searchRequest.duplicate();
            pagedResultsSearchRequest.addControl(new SimplePagedResultsControl(pageSize, pagedResultsCookie, true));
            try {
                searchResult = connection.search(pagedResultsSearchRequest);
            }
            catch (LDAPSearchException e) {
                Debug.debugException(e);
                searchResult = e.getSearchResult();
            }
            if (searchResult.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                return;
            }
            if (searchResult.getResultCode() != ResultCode.SUCCESS) {
                throw new LDAPSearchException(searchResult);
            }
            if (searchListener.getFirstException() != null) {
                throw new LDAPSearchException(searchListener.getFirstException());
            }
            try {
                responseControl = SimplePagedResultsControl.get(searchResult);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                throw new LDAPSearchException(e);
            }
            if (responseControl == null) {
                throw new LDAPSearchException(ResultCode.CONTROL_NOT_FOUND, UtilityMessages.ERR_SUBTREE_DELETER_MISSING_PAGED_RESULTS_RESPONSE.get(searchRequest.getBaseDN(), searchRequest.getFilter()));
            }
            if (!responseControl.moreResultsToReturn()) break;
            pagedResultsCookie = responseControl.getCookie();
        }
    }

    private static boolean deleteEntry(@NotNull LDAPInterface connection, @NotNull DN dn, @NotNull List<Control> deleteControls, @NotNull AtomicLong entriesDeleted, @NotNull SortedMap<DN, LDAPResult> deleteErrors, @Nullable FixedRateBarrier deleteRateLimiter, int searchRequestSizeLimit, @NotNull List<Control> searchControls, boolean useSubentriesControl, @NotNull AtomicReference<SearchResult> searchError) {
        LDAPResult deleteResult;
        if (deleteRateLimiter != null) {
            deleteRateLimiter.await();
        }
        try {
            deleteResult = connection.delete(dn.toString());
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            deleteResult = e.toLDAPResult();
        }
        ResultCode resultCode = deleteResult.getResultCode();
        if (resultCode == ResultCode.SUCCESS) {
            entriesDeleted.incrementAndGet();
            return true;
        }
        if (resultCode == ResultCode.NO_SUCH_OBJECT) {
            return true;
        }
        if (resultCode == ResultCode.NOT_ALLOWED_ON_NONLEAF) {
            return SubtreeDeleter.searchAndDelete(connection, dn, searchRequestSizeLimit, searchControls, useSubentriesControl, searchError, deleteControls, entriesDeleted, deleteErrors, deleteRateLimiter);
        }
        deleteErrors.put(dn, deleteResult);
        return false;
    }

    private static boolean searchAndDelete(@NotNull LDAPInterface connection, @NotNull DN baseDN, int searchRequestSizeLimit, @NotNull List<Control> searchControls, boolean useSubentriesControl, @NotNull AtomicReference<SearchResult> searchError, @NotNull List<Control> deleteControls, @NotNull AtomicLong entriesDeleted, @NotNull SortedMap<DN, LDAPResult> deleteErrors, @Nullable FixedRateBarrier deleteRateLimiter) {
        while (true) {
            SearchResult nonSubentriesSearchResult;
            SearchResult subentriesSearchResult = null;
            TreeSet<DN> dnsToDelete = new TreeSet<DN>();
            if (useSubentriesControl) {
                try {
                    subentriesSearchResult = connection.search(SubtreeDeleter.createSubentriesSearchRequest(baseDN, searchRequestSizeLimit, searchControls, dnsToDelete));
                }
                catch (LDAPSearchException e) {
                    Debug.debugException(e);
                    subentriesSearchResult = e.getSearchResult();
                }
            }
            try {
                nonSubentriesSearchResult = connection.search(SubtreeDeleter.createNonSubentriesSearchRequest(baseDN, searchRequestSizeLimit, searchControls, dnsToDelete));
            }
            catch (LDAPSearchException e) {
                Debug.debugException(e);
                nonSubentriesSearchResult = e.getSearchResult();
            }
            if (dnsToDelete.isEmpty()) {
                if (subentriesSearchResult != null) {
                    switch (subentriesSearchResult.getResultCode().intValue()) {
                        case 0: 
                        case 32: {
                            break;
                        }
                        default: {
                            searchError.compareAndSet(null, subentriesSearchResult);
                            return false;
                        }
                    }
                }
                switch (nonSubentriesSearchResult.getResultCode().intValue()) {
                    case 0: 
                    case 32: {
                        break;
                    }
                    default: {
                        searchError.compareAndSet(null, nonSubentriesSearchResult);
                        return false;
                    }
                }
                return true;
            }
            boolean anySuccessful = false;
            boolean allSuccessful = true;
            TreeSet<DN> ancestorsToSkip = new TreeSet<DN>();
            DeleteRequest deleteRequest = new DeleteRequest("");
            deleteRequest.setControls(deleteControls);
            block26: for (DN dn : dnsToDelete.descendingSet()) {
                LDAPResult deleteResult;
                if (deleteErrors.containsKey(dn)) {
                    allSuccessful = false;
                    continue;
                }
                if (ancestorsToSkip.contains(dn)) {
                    allSuccessful = false;
                    continue;
                }
                if (deleteRateLimiter != null) {
                    deleteRateLimiter.await();
                }
                try {
                    deleteRequest.setDN(dn);
                    deleteResult = connection.delete(deleteRequest);
                }
                catch (LDAPException e) {
                    Debug.debugException(e);
                    deleteResult = e.toLDAPResult();
                }
                switch (deleteResult.getResultCode().intValue()) {
                    case 0: {
                        anySuccessful = true;
                        entriesDeleted.incrementAndGet();
                        break;
                    }
                    case 32: {
                        anySuccessful = true;
                        break;
                    }
                    case 66: {
                        DN parentDN;
                        if (dn.equals(baseDN)) {
                            allSuccessful = false;
                            break;
                        }
                        if (SubtreeDeleter.searchAndDelete(connection, dn, searchRequestSizeLimit, searchControls, useSubentriesControl, searchError, deleteControls, entriesDeleted, deleteErrors, deleteRateLimiter)) {
                            anySuccessful = true;
                            break;
                        }
                        allSuccessful = false;
                        for (parentDN = dn.getParent(); parentDN != null; parentDN = parentDN.getParent()) {
                            ancestorsToSkip.add(parentDN);
                        }
                        continue block26;
                    }
                    default: {
                        DN parentDN;
                        deleteErrors.put(dn, deleteResult);
                        for (parentDN = dn.getParent(); parentDN != null && parentDN.isDescendantOf(baseDN, true); parentDN = parentDN.getParent()) {
                            deleteErrors.put(parentDN, new LDAPResult(-1, ResultCode.NOT_ALLOWED_ON_NONLEAF, UtilityMessages.ERR_SUBTREE_DELETER_SKIPPING_UNDELETABLE_ANCESTOR.get(String.valueOf(parentDN), String.valueOf(dn)), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS));
                        }
                        allSuccessful = false;
                    }
                }
            }
            if (subentriesSearchResult != null) {
                switch (subentriesSearchResult.getResultCode().intValue()) {
                    case 0: 
                    case 32: {
                        break;
                    }
                    case 4: {
                        if (anySuccessful) break;
                        searchError.compareAndSet(null, subentriesSearchResult);
                        break;
                    }
                    default: {
                        searchError.compareAndSet(null, subentriesSearchResult);
                    }
                }
            }
            switch (nonSubentriesSearchResult.getResultCode().intValue()) {
                case 0: 
                case 32: {
                    break;
                }
                case 4: {
                    if (anySuccessful) break;
                    searchError.compareAndSet(null, nonSubentriesSearchResult);
                    break;
                }
                default: {
                    searchError.compareAndSet(null, nonSubentriesSearchResult);
                }
            }
            if (allSuccessful) {
                if (!dnsToDelete.contains(baseDN)) continue;
                return true;
            }
            if (!anySuccessful) break;
        }
        return false;
    }

    @NotNull
    private static SubtreeDeleterResult deleteEntriesWithoutSimplePagedResults(@NotNull LDAPInterface connection, @NotNull DN baseDN, boolean deleteBaseEntry, int searchRequestSizeLimit, boolean useSubentriesControl, @NotNull List<Control> searchControls, @NotNull List<Control> deleteControls, @Nullable FixedRateBarrier deleteRateLimiter) {
        SearchRequest searchRequest;
        TreeSet<DN> dnsToDelete = new TreeSet<DN>();
        AtomicReference<SearchResult> searchError = new AtomicReference<SearchResult>();
        AtomicLong entriesDeleted = new AtomicLong(0L);
        TreeMap<DN, LDAPResult> deleteErrors = new TreeMap<DN, LDAPResult>();
        if (useSubentriesControl) {
            searchRequest = SubtreeDeleter.createSubentriesSearchRequest(baseDN, searchRequestSizeLimit, searchControls, dnsToDelete);
            SubtreeDeleter.searchAndDelete(connection, baseDN, searchRequest, useSubentriesControl, searchControls, dnsToDelete, searchError, deleteBaseEntry, deleteControls, deleteRateLimiter, entriesDeleted, deleteErrors);
        }
        searchRequest = SubtreeDeleter.createNonSubentriesSearchRequest(baseDN, searchRequestSizeLimit, searchControls, dnsToDelete);
        SubtreeDeleter.searchAndDelete(connection, baseDN, searchRequest, useSubentriesControl, searchControls, dnsToDelete, searchError, deleteBaseEntry, deleteControls, deleteRateLimiter, entriesDeleted, deleteErrors);
        return new SubtreeDeleterResult(null, false, searchError.get(), entriesDeleted.get(), deleteErrors);
    }

    private static void searchAndDelete(@NotNull LDAPInterface connection, @NotNull DN baseDN, @NotNull SearchRequest searchRequest, boolean useSubentriesControl, @NotNull List<Control> searchControls, @NotNull TreeSet<DN> dnsToDelete, @NotNull AtomicReference<SearchResult> searchError, boolean deleteBaseEntry, @NotNull List<Control> deleteControls, @Nullable FixedRateBarrier deleteRateLimiter, @NotNull AtomicLong entriesDeleted, @NotNull SortedMap<DN, LDAPResult> deleteErrors) {
        SearchResult searchResult;
        long beforeDeleteCount;
        long afterDeleteCount;
        do {
            ResultCode searchResultCode;
            beforeDeleteCount = entriesDeleted.get();
            try {
                searchResult = connection.search(searchRequest);
            }
            catch (LDAPSearchException e) {
                Debug.debugException(e);
                searchResult = e.getSearchResult();
            }
            if (searchError.get() == null && (searchResultCode = searchResult.getResultCode()) != ResultCode.SUCCESS) {
                if (searchResultCode == ResultCode.NO_SUCH_OBJECT) {
                    return;
                }
                if (searchResultCode != ResultCode.SIZE_LIMIT_EXCEEDED) {
                    searchError.compareAndSet(null, searchResult);
                }
            }
            if (!deleteBaseEntry) {
                dnsToDelete.remove(baseDN);
            }
            Iterator<DN> dnIterator = dnsToDelete.descendingIterator();
            while (dnIterator.hasNext()) {
                DN dnToDelete = dnIterator.next();
                dnIterator.remove();
                if (deleteErrors.containsKey(dnToDelete) || SubtreeDeleter.deleteEntry(connection, dnToDelete, deleteControls, entriesDeleted, deleteErrors, deleteRateLimiter, searchRequest.getSizeLimit(), searchControls, useSubentriesControl, searchError)) continue;
                for (DN parentDN = dnToDelete.getParent(); parentDN != null && parentDN.isDescendantOf(baseDN, true) && !deleteErrors.containsKey(parentDN); parentDN = parentDN.getParent()) {
                    deleteErrors.put(parentDN, new LDAPResult(-1, ResultCode.NOT_ALLOWED_ON_NONLEAF, UtilityMessages.ERR_SUBTREE_DELETER_SKIPPING_UNDELETABLE_ANCESTOR.get(String.valueOf(parentDN), String.valueOf(dnToDelete)), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS));
                }
            }
        } while ((afterDeleteCount = entriesDeleted.get()) != beforeDeleteCount);
        if (searchResult.getResultCode() == ResultCode.SIZE_LIMIT_EXCEEDED) {
            searchError.compareAndSet(null, searchResult);
        }
    }

    @NotNull
    private static ExtendedResult removeAccessibilityRestriction(@NotNull LDAPInterface connection, @NotNull DN baseDN) {
        return SubtreeDeleter.processExtendedOperation(connection, SetSubtreeAccessibilityExtendedRequest.createSetAccessibleRequest(baseDN.toString(), new Control[0]));
    }

    @NotNull
    private static ExtendedResult processExtendedOperation(@NotNull LDAPInterface connection, @NotNull ExtendedRequest request) {
        try {
            if (connection instanceof LDAPConnection) {
                return ((LDAPConnection)connection).processExtendedOperation(request);
            }
            if (connection instanceof AbstractConnectionPool) {
                return ((AbstractConnectionPool)connection).processExtendedOperation(request);
            }
            return new ExtendedResult(-1, ResultCode.PARAM_ERROR, UtilityMessages.ERR_SUBTREE_DELETER_INTERFACE_EXTOP_NOT_SUPPORTED.get(connection.getClass().getName()), null, StaticUtils.NO_STRINGS, null, null, StaticUtils.NO_CONTROLS);
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            return new ExtendedResult(e);
        }
    }

    private static boolean supportsExtendedRequest(@NotNull LDAPInterface connection, @NotNull AtomicReference<RootDSE> rootDSE, @NotNull String oid) {
        RootDSE dse = SubtreeDeleter.getRootDSE(connection, rootDSE);
        if (dse == null) {
            return false;
        }
        return dse.supportsExtendedOperation(oid);
    }

    private static boolean supportsControl(@NotNull LDAPInterface connection, @NotNull AtomicReference<RootDSE> rootDSE, @NotNull String oid) {
        RootDSE dse = SubtreeDeleter.getRootDSE(connection, rootDSE);
        if (dse == null) {
            return false;
        }
        return dse.supportsControl(oid);
    }

    @Nullable
    private static RootDSE getRootDSE(@NotNull LDAPInterface connection, @NotNull AtomicReference<RootDSE> rootDSE) {
        RootDSE dse = rootDSE.get();
        if (dse != null) {
            return dse;
        }
        try {
            return connection.getRootDSE();
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("SubtreeDeleter(deleteBaseEntry=");
        buffer.append(this.deleteBaseEntry);
        buffer.append(", useSetSubtreeAccessibilityOperationIfAvailable=");
        buffer.append(this.useSetSubtreeAccessibilityOperationIfAvailable);
        if (this.useSimplePagedResultsControlIfAvailable) {
            buffer.append(", useSimplePagedResultsControlIfAvailable=true, pageSize=");
            buffer.append(this.simplePagedResultsPageSize);
        } else {
            buffer.append(", useSimplePagedResultsControlIfAvailable=false");
        }
        buffer.append(", useManageDSAITControlIfAvailable=");
        buffer.append(this.useManageDSAITControlIfAvailable);
        buffer.append(", usePermitUnindexedSearchControlIfAvailable=");
        buffer.append(this.usePermitUnindexedSearchControlIfAvailable);
        buffer.append(", useSubentriesControlIfAvailable=");
        buffer.append(this.useSubentriesControlIfAvailable);
        buffer.append(", useReturnConflictEntriesRequestControlIfAvailable=");
        buffer.append(this.useReturnConflictEntriesRequestControlIfAvailable);
        buffer.append(", useSoftDeletedEntryAccessControlIfAvailable=");
        buffer.append(this.useSoftDeletedEntryAccessControlIfAvailable);
        buffer.append(", useHardDeleteControlIfAvailable=");
        buffer.append(this.useHardDeleteControlIfAvailable);
        buffer.append(", additionalSearchControls={ ");
        Iterator<Control> searchControlIterator = this.additionalSearchControls.iterator();
        while (searchControlIterator.hasNext()) {
            buffer.append(searchControlIterator.next());
            if (searchControlIterator.hasNext()) {
                buffer.append(',');
            }
            buffer.append(' ');
        }
        buffer.append("}, additionalDeleteControls={");
        Iterator<Control> deleteControlIterator = this.additionalSearchControls.iterator();
        while (deleteControlIterator.hasNext()) {
            buffer.append(deleteControlIterator.next());
            if (deleteControlIterator.hasNext()) {
                buffer.append(',');
            }
            buffer.append(' ');
        }
        buffer.append("}, searchRequestSizeLimit=");
        buffer.append(this.searchRequestSizeLimit);
        buffer.append(')');
    }
}

