/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model.mailbox;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.jmap.draft.exceptions.JmapFieldNotSupportedException;
import org.apache.james.jmap.draft.model.MailboxCreationId;
import org.apache.james.jmap.draft.model.mailbox.SortOrder;
import org.apache.james.mailbox.Role;

@JsonDeserialize(builder=Builder.class)
public class MailboxCreateRequest {
    private static final String ISSUER = "MailboxCreateRequest";
    private final Optional<String> id;
    private final String name;
    private final Optional<MailboxCreationId> parentId;
    private final Optional<Role> role;
    private final Optional<SortOrder> sortOrder;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    MailboxCreateRequest(Optional<String> id, String name, Optional<MailboxCreationId> parentId, Optional<Role> role, Optional<SortOrder> sortOrder) {
        this.id = id;
        this.name = name;
        this.parentId = parentId;
        this.role = role;
        this.sortOrder = sortOrder;
    }

    public Optional<String> getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Optional<MailboxCreationId> getParentId() {
        return this.parentId;
    }

    public Optional<Role> getRole() {
        return this.role;
    }

    public Optional<SortOrder> getSortOrder() {
        return this.sortOrder;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof MailboxCreateRequest) {
            MailboxCreateRequest other = (MailboxCreateRequest)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.parentId, other.parentId) && Objects.equals(this.role, other.role) && Objects.equals(this.sortOrder, other.sortOrder);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.id, this.name, this.parentId, this.role, this.sortOrder);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", this.id).add("name", (Object)this.name).add("parentId", this.parentId).add("role", this.role).add("sortOrder", this.sortOrder).toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private Optional<String> id = Optional.empty();
        private String name;
        private Optional<MailboxCreationId> parentId;
        private Optional<Role> role = Optional.empty();
        private Optional<SortOrder> sortOrder = Optional.empty();

        private Builder() {
            this.parentId = Optional.empty();
        }

        public Builder id(String id) {
            Preconditions.checkNotNull((Object)id);
            this.id = Optional.of(id);
            return this;
        }

        public Builder name(String name) {
            Preconditions.checkNotNull((Object)name);
            this.name = name;
            return this;
        }

        public Builder parentId(MailboxCreationId parentId) {
            Preconditions.checkNotNull((Object)parentId);
            this.parentId = Optional.of(parentId);
            return this;
        }

        public Builder role(Role role) {
            Preconditions.checkNotNull((Object)role);
            throw new JmapFieldNotSupportedException(MailboxCreateRequest.ISSUER, "role");
        }

        public Builder sortOrder(SortOrder sortOrder) {
            Preconditions.checkNotNull((Object)sortOrder);
            throw new JmapFieldNotSupportedException(MailboxCreateRequest.ISSUER, "sortOrder");
        }

        public MailboxCreateRequest build() {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.name) ? 1 : 0) != 0, (Object)"'name' is mandatory");
            return new MailboxCreateRequest(this.id, this.name, this.parentId, this.role, this.sortOrder);
        }
    }
}

