/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.lambdas.comparators;

import com.github.fge.lambdas.Chainer;
import com.github.fge.lambdas.comparators.ThrowingComparator;
import java.util.Comparator;

public class ComparatorChainer<T>
extends Chainer<Comparator<T>, ThrowingComparator<T>, ComparatorChainer<T>>
implements ThrowingComparator<T> {
    public ComparatorChainer(ThrowingComparator<T> throwing) {
        super(throwing);
    }

    @Override
    public int doCompare(T o1, T o2) throws Throwable {
        return ((ThrowingComparator)this.throwing).doCompare(o1, o2);
    }

    @Override
    public ComparatorChainer<T> orTryWith(ThrowingComparator<T> other) {
        ThrowingComparator<Object> comparator = (o1, o2) -> {
            try {
                return ((ThrowingComparator)this.throwing).doCompare(o1, o2);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable throwable) {
                return other.doCompare(o1, o2);
            }
        };
        return new ComparatorChainer<Object>(comparator);
    }

    @Override
    public <E extends RuntimeException> ThrowingComparator<T> orThrow(Class<E> exclass) {
        return (o1, o2) -> {
            try {
                return ((ThrowingComparator)this.throwing).doCompare(o1, o2);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw ComparatorChainer.rethrow(exclass, throwable);
            }
        };
    }

    @Override
    public Comparator<T> fallbackTo(Comparator<T> fallback) {
        return (o1, o2) -> {
            try {
                return ((ThrowingComparator)this.throwing).doCompare(o1, o2);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable ignored) {
                return fallback.compare(o1, o2);
            }
        };
    }

    @Override
    public Comparator<T> sneakyThrow() {
        return (o1, o2) -> {
            try {
                return ((ThrowingComparator)this.throwing).doCompare(o1, o2);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw ComparatorChainer.doSneakyThrow(throwable);
            }
        };
    }

    public Comparator<T> orReturn(int retval) {
        return (o1, o2) -> {
            try {
                return ((ThrowingComparator)this.throwing).doCompare(o1, o2);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable ignored) {
                return retval;
            }
        };
    }
}

