/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.Set;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueName;

public interface MailQueueFactory<T extends MailQueue> {
    public static final MailQueueName SPOOL = MailQueueName.of("spool");

    public static PrefetchCount defaultPrefetchCount() {
        return MailQueueFactory.prefetchCount(5);
    }

    public static PrefetchCount prefetchCount(int count) {
        return new PrefetchCount(count);
    }

    default public Optional<T> getQueue(MailQueueName name) {
        return this.getQueue(name, MailQueueFactory.defaultPrefetchCount());
    }

    public Optional<T> getQueue(MailQueueName var1, PrefetchCount var2);

    default public T createQueue(MailQueueName name) {
        return this.createQueue(name, MailQueueFactory.defaultPrefetchCount());
    }

    public T createQueue(MailQueueName var1, PrefetchCount var2);

    public Set<MailQueueName> listCreatedMailQueues();

    public static class PrefetchCount {
        private final int value;

        @VisibleForTesting
        PrefetchCount(int value) {
            Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)"only non-negative values are allowed");
            this.value = value;
        }

        public int asInt() {
            return this.value;
        }

        public String toString() {
            return "PrefetchCount = " + this.value;
        }
    }
}

