/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.EnumSet;
import java.util.function.Consumer;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class FieldValue
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    public static final FieldValue NULL = new FieldValue(Kind.Null, null);
    public static final FieldValue TRUE = new FieldValue(Kind.Boolean, Boolean.TRUE);
    public static final FieldValue FALSE = new FieldValue(Kind.Boolean, Boolean.FALSE);
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<FieldValue> _DESERIALIZER = JsonpDeserializer.lazy(() -> JsonpDeserializer.of(EnumSet.of(JsonParser.Event.VALUE_STRING, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_NULL, JsonParser.Event.VALUE_TRUE, JsonParser.Event.VALUE_FALSE), (parser, mapper, event) -> {
        switch (event) {
            case VALUE_NULL: {
                return NULL;
            }
            case VALUE_STRING: {
                return FieldValue.of(parser.getString());
            }
            case VALUE_TRUE: {
                return FieldValue.of(true);
            }
            case VALUE_FALSE: {
                return FieldValue.of(false);
            }
            case VALUE_NUMBER: {
                if (parser.isIntegralNumber()) {
                    return FieldValue.of(parser.getLong());
                }
                return FieldValue.of(parser.getBigDecimal().doubleValue());
            }
        }
        return null;
    }));

    public static FieldValue of(long value) {
        return new FieldValue(Kind.Long, value);
    }

    public static FieldValue of(double value) {
        return new FieldValue(Kind.Double, value);
    }

    public static FieldValue of(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static FieldValue of(String value) {
        return new FieldValue(Kind.String, value);
    }

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public String _toJsonString() {
        switch (this._kind) {
            case Double: {
                return String.valueOf(this.doubleValue());
            }
            case Long: {
                return String.valueOf(this.longValue());
            }
            case Boolean: {
                return String.valueOf(this.booleanValue());
            }
            case String: {
                return this.stringValue();
            }
            case Null: {
                return "null";
            }
        }
        throw new IllegalStateException("Unknown kind " + (Object)((Object)this._kind));
    }

    private FieldValue(Builder builder) {
        this(builder._kind, builder._value);
    }

    private FieldValue(Kind kind, Object value) {
        this._kind = ApiTypeHelper.requireNonNull(kind, this, "<variant kind>");
        this._value = kind == Kind.Null ? null : ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    public static FieldValue of(Consumer<Builder> fn) {
        Builder builder = new Builder();
        fn.accept(builder);
        return builder.build();
    }

    public boolean isDouble() {
        return this._kind == Kind.Double;
    }

    public double doubleValue() {
        return (Double)TaggedUnionUtils.get(this, Kind.Double);
    }

    public boolean isLong() {
        return this._kind == Kind.Long;
    }

    public long longValue() {
        return (Long)TaggedUnionUtils.get(this, Kind.Long);
    }

    public boolean isBoolean() {
        return this._kind == Kind.Boolean;
    }

    public boolean booleanValue() {
        return (Boolean)TaggedUnionUtils.get(this, Kind.Boolean);
    }

    public boolean isString() {
        return this._kind == Kind.String;
    }

    public String stringValue() {
        return (String)TaggedUnionUtils.get(this, Kind.String);
    }

    public boolean isNull() {
        return this._kind == Kind.Null;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        switch (this._kind) {
            case Double: {
                generator.write(((Double)this._value).doubleValue());
                break;
            }
            case Long: {
                generator.write(((Long)this._value).longValue());
                break;
            }
            case Boolean: {
                generator.write(((Boolean)this._value).booleanValue());
                break;
            }
            case String: {
                generator.write((String)this._value);
                break;
            }
            case Null: {
                generator.writeNull();
            }
        }
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<FieldValue> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<FieldValue> doubleValue(double v) {
            this._kind = Kind.Double;
            this._value = v;
            return this;
        }

        public ObjectBuilder<FieldValue> longValue(long v) {
            this._kind = Kind.Long;
            this._value = v;
            return this;
        }

        public ObjectBuilder<FieldValue> booleanValue(boolean v) {
            this._kind = Kind.Boolean;
            this._value = v;
            return this;
        }

        public ObjectBuilder<FieldValue> stringValue(String v) {
            this._kind = Kind.String;
            this._value = v;
            return this;
        }

        public ObjectBuilder<FieldValue> nullValue() {
            this._kind = Kind.Null;
            this._value = null;
            return this;
        }

        @Override
        public FieldValue build() {
            this._checkSingleUse();
            return new FieldValue(this);
        }
    }

    public static enum Kind {
        Double,
        Long,
        Boolean,
        String,
        Null;

    }
}

