/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class DataPathStats
implements PlainJsonSerializable {
    private final long availableInBytes;
    private final long freeInBytes;
    @Nullable
    private final String mount;
    @Nullable
    private final String path;
    private final long totalInBytes;
    private final String type;
    public static final JsonpDeserializer<DataPathStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataPathStats::setupDataPathStatsDeserializer);

    private DataPathStats(Builder builder) {
        this.availableInBytes = ApiTypeHelper.requireNonNull(builder.availableInBytes, this, "availableInBytes");
        this.freeInBytes = ApiTypeHelper.requireNonNull(builder.freeInBytes, this, "freeInBytes");
        this.mount = builder.mount;
        this.path = builder.path;
        this.totalInBytes = ApiTypeHelper.requireNonNull(builder.totalInBytes, this, "totalInBytes");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static DataPathStats of(Function<Builder, ObjectBuilder<DataPathStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long availableInBytes() {
        return this.availableInBytes;
    }

    public final long freeInBytes() {
        return this.freeInBytes;
    }

    @Nullable
    public final String mount() {
        return this.mount;
    }

    @Nullable
    public final String path() {
        return this.path;
    }

    public final long totalInBytes() {
        return this.totalInBytes;
    }

    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("available_in_bytes");
        generator.write(this.availableInBytes);
        generator.writeKey("free_in_bytes");
        generator.write(this.freeInBytes);
        if (this.mount != null) {
            generator.writeKey("mount");
            generator.write(this.mount);
        }
        if (this.path != null) {
            generator.writeKey("path");
            generator.write(this.path);
        }
        generator.writeKey("total_in_bytes");
        generator.write(this.totalInBytes);
        generator.writeKey("type");
        generator.write(this.type);
    }

    protected static void setupDataPathStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::availableInBytes, JsonpDeserializer.longDeserializer(), "available_in_bytes");
        op.add(Builder::freeInBytes, JsonpDeserializer.longDeserializer(), "free_in_bytes");
        op.add(Builder::mount, JsonpDeserializer.stringDeserializer(), "mount");
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path");
        op.add(Builder::totalInBytes, JsonpDeserializer.longDeserializer(), "total_in_bytes");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DataPathStats> {
        private Long availableInBytes;
        private Long freeInBytes;
        @Nullable
        private String mount;
        @Nullable
        private String path;
        private Long totalInBytes;
        private String type;

        public final Builder availableInBytes(long value) {
            this.availableInBytes = value;
            return this;
        }

        public final Builder freeInBytes(long value) {
            this.freeInBytes = value;
            return this;
        }

        public final Builder mount(@Nullable String value) {
            this.mount = value;
            return this;
        }

        public final Builder path(@Nullable String value) {
            this.path = value;
            return this;
        }

        public final Builder totalInBytes(long value) {
            this.totalInBytes = value;
            return this;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        public DataPathStats build() {
            this._checkSingleUse();
            return new DataPathStats(this);
        }
    }
}

