/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.search;

import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Collection;
import java.util.Locale;
import org.apache.james.core.MailAddress;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.vault.search.Criterion;
import org.apache.james.vault.search.DeletedMessageField;
import org.apache.james.vault.search.Operator;

public interface CriterionFactory {
    public static ZonedDateTimeCriterionFactory deletionDate() {
        return new ZonedDateTimeCriterionFactory(Criterion.Builder.forField(DeletedMessageField.DELETION_DATE));
    }

    public static ZonedDateTimeCriterionFactory deliveryDate() {
        return new ZonedDateTimeCriterionFactory(Criterion.Builder.forField(DeletedMessageField.DELIVERY_DATE));
    }

    public static Criterion<Collection<MailAddress>> containsRecipient(MailAddress recipient) {
        return Criterion.Builder.forField(DeletedMessageField.RECIPIENTS).withMatcher(new Criterion.ValueMatcher<MailAddress, Collection>(recipient, Operator.CONTAINS, value -> value.contains(recipient)));
    }

    public static Criterion<MailAddress> hasSender(MailAddress sender) {
        return Criterion.Builder.forField(DeletedMessageField.SENDER).withMatcher(new Criterion.ValueMatcher<MailAddress, MailAddress>(sender, Operator.EQUALS, arg_0 -> ((MailAddress)sender).equals(arg_0)));
    }

    public static Criterion<Boolean> hasAttachment() {
        return CriterionFactory.hasAttachment(true);
    }

    public static Criterion<Boolean> hasNoAttachment() {
        return CriterionFactory.hasAttachment(false);
    }

    public static Criterion<Boolean> hasAttachment(boolean hasAttachment) {
        return Criterion.Builder.forField(DeletedMessageField.HAS_ATTACHMENT).withMatcher(new Criterion.ValueMatcher<Boolean, Boolean>(hasAttachment, Operator.EQUALS, value -> hasAttachment == value));
    }

    public static StringCriterionFactory subject() {
        return new StringCriterionFactory(Criterion.Builder.forField(DeletedMessageField.SUBJECT));
    }

    public static Criterion<Collection<MailboxId>> containsOriginMailbox(MailboxId mailboxId) {
        return Criterion.Builder.forField(DeletedMessageField.ORIGIN_MAILBOXES).withMatcher(new Criterion.ValueMatcher<MailboxId, Collection>(mailboxId, Operator.CONTAINS, value -> value.contains(mailboxId)));
    }

    public static class ZonedDateTimeCriterionFactory {
        private final Criterion.ExpectMatcher<ZonedDateTime> builder;

        private ZonedDateTimeCriterionFactory(Criterion.ExpectMatcher<ZonedDateTime> builder) {
            this.builder = builder;
        }

        public Criterion<ZonedDateTime> beforeOrEquals(ZonedDateTime expectedValue) {
            return this.builder.withMatcher(new Criterion.ValueMatcher<ZonedDateTime, ZonedDateTime>(expectedValue, Operator.BEFORE_OR_EQUALS, value -> !expectedValue.isBefore((ChronoZonedDateTime<?>)value)));
        }

        public Criterion<ZonedDateTime> afterOrEquals(ZonedDateTime expectedValue) {
            return this.builder.withMatcher(new Criterion.ValueMatcher<ZonedDateTime, ZonedDateTime>(expectedValue, Operator.AFTER_OR_EQUALS, value -> !expectedValue.isAfter((ChronoZonedDateTime<?>)value)));
        }
    }

    public static class StringCriterionFactory {
        private final Criterion.ExpectMatcher<String> builder;

        private StringCriterionFactory(Criterion.ExpectMatcher<String> builder) {
            this.builder = builder;
        }

        public Criterion<String> contains(String subString) {
            return this.builder.withMatcher(new Criterion.ValueMatcher<String, String>(subString, Operator.CONTAINS, value -> value.contains(subString)));
        }

        public Criterion<String> containsIgnoreCase(String subString) {
            return this.builder.withMatcher(new Criterion.ValueMatcher<String, String>(subString, Operator.CONTAINS_IGNORE_CASE, value -> value.toLowerCase(Locale.US).contains(subString.toLowerCase(Locale.US))));
        }

        public Criterion<String> equals(String expectedString) {
            return this.builder.withMatcher(new Criterion.ValueMatcher<String, String>(expectedString, Operator.EQUALS, expectedString::equals));
        }

        public Criterion<String> equalsIgnoreCase(String expectedString) {
            return this.builder.withMatcher(new Criterion.ValueMatcher<String, String>(expectedString, Operator.EQUALS_IGNORE_CASE, expectedString::equalsIgnoreCase));
        }
    }
}

