/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.FSGenerator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.CommonArray_Type;
import org.apache.uima.jcas.cas.FloatArray;

public class FloatArray_Type
extends CommonArray_Type {
    public static final int typeIndexID = FloatArray.typeIndexID;

    @Override
    protected FSGenerator<?> getFSGenerator() {
        return null;
    }

    private FloatArray_Type() {
    }

    public FloatArray_Type(JCas jcas, Type casType) {
        super(jcas, casType);
    }

    public float get(int addr, int i) {
        if (this.lowLevelTypeChecks) {
            return this.ll_cas.ll_getFloatArrayValue(addr, i, true);
        }
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, i);
        }
        return this.ll_cas.ll_getFloatArrayValue(addr, i);
    }

    public void set(int addr, int i, float value) {
        if (this.lowLevelTypeChecks) {
            this.ll_cas.ll_setFloatArrayValue(addr, i, value, true);
        }
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, i);
        }
        this.ll_cas.ll_setFloatArrayValue(addr, i, value);
    }

    public void copyFromArray(int addr, float[] src, int srcOffset, int destOffset, int length) {
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, destOffset, length);
        }
        for (int i = 0; i < length; ++i) {
            this.ll_cas.ll_setFloatArrayValue(addr, i + destOffset, src[i + srcOffset]);
        }
    }

    public void copyToArray(int addr, int srcOffset, float[] dest, int destOffset, int length) {
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, srcOffset, length);
        }
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.ll_cas.ll_getFloatArrayValue(addr, i + srcOffset);
        }
    }

    public float[] toArray(int addr) {
        int size = this.size(addr);
        float[] outArray = new float[size];
        this.copyToArray(addr, 0, outArray, 0, size);
        return outArray;
    }
}

