/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import org.exolab.castor.jdo.engine.JDOClassDescriptor;
import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;

public class SQLFieldInfo {
    private final String _tableName;
    private final boolean _store;
    private final boolean _multi;
    private final boolean _joined;
    private final boolean _dirtyCheck;
    private final String[] _joinFields;
    private final SQLColumnInfo[] _columns;
    private final FieldDescriptor _fieldDescriptor;

    public SQLFieldInfo(JDOClassDescriptor clsDesc, FieldDescriptor fieldDesc, String classTable, boolean ext) throws MappingException {
        this._fieldDescriptor = fieldDesc;
        ClassDescriptor related = fieldDesc.getClassDescriptor();
        if (related != null) {
            if (!(related instanceof JDOClassDescriptor)) {
                throw new MappingException("Related class is not JDOClassDescriptor");
            }
            FieldDescriptor[] relids = ((JDOClassDescriptor)related).getIdentities();
            String[] relnames = new String[relids.length];
            for (int i = 0; i < relids.length; ++i) {
                relnames[i] = ((JDOFieldDescriptor)relids[i]).getSQLName()[0];
                if (relnames[i] != null) continue;
                throw new MappingException("Related class identities field does not contains sql information!");
            }
            FieldDescriptor[] classids = clsDesc.getIdentities();
            String[] classnames = new String[classids.length];
            for (int i = 0; i < classids.length; ++i) {
                classnames[i] = ((JDOFieldDescriptor)classids[i]).getSQLName()[0];
                if (classnames[i] != null) continue;
                throw new MappingException("Related class identities field does not contains sql information!");
            }
            String[] names = relnames;
            if (!(fieldDesc instanceof JDOFieldDescriptor)) {
                this._tableName = ((JDOClassDescriptor)related).getTableName();
                this._store = false;
                this._multi = fieldDesc.isMultivalued();
                this._joined = true;
                this._joinFields = classnames;
                this._dirtyCheck = true;
            } else {
                JDOFieldDescriptor jdoFieldDesc = (JDOFieldDescriptor)fieldDesc;
                names = jdoFieldDesc.getSQLName();
                if (names != null && names.length != relids.length) {
                    throw new MappingException("The number of column of foreign keys doesn't not match with what specified in manyKey");
                }
                names = names != null ? names : relnames;
                String[] joins = jdoFieldDesc.getManyKey();
                if (joins != null && joins.length != classids.length) {
                    throw new MappingException("The number of column of foreign keys doesn't not match with what specified in manyKey");
                }
                if (jdoFieldDesc.getManyTable() != null) {
                    this._tableName = jdoFieldDesc.getManyTable();
                    this._store = false;
                    this._multi = jdoFieldDesc.isMultivalued();
                    this._joined = true;
                    this._joinFields = joins != null ? joins : classnames;
                } else if (jdoFieldDesc.getSQLName() != null) {
                    this._tableName = classTable;
                    this._store = !ext && !jdoFieldDesc.isReadonly();
                    this._multi = false;
                    this._joined = false;
                    this._joinFields = classnames;
                } else {
                    this._tableName = ((JDOClassDescriptor)related).getTableName();
                    this._store = false;
                    this._multi = jdoFieldDesc.isMultivalued();
                    this._joined = true;
                    this._joinFields = joins != null ? joins : classnames;
                }
                this._dirtyCheck = jdoFieldDesc.isDirtyCheck();
            }
            this._columns = new SQLColumnInfo[relids.length];
            for (int i = 0; i < relids.length; ++i) {
                if (!(relids[i] instanceof JDOFieldDescriptor)) {
                    throw new MappingException("Related class identities field does not contains sql information!");
                }
                JDOFieldDescriptor relId = (JDOFieldDescriptor)relids[i];
                FieldHandlerImpl fh = (FieldHandlerImpl)relId.getHandler();
                this._columns[i] = new SQLColumnInfo(names[i], relId.getSQLType()[0], fh.getConvertTo(), fh.getConvertFrom(), fh.getConvertParam());
            }
        } else {
            JDOFieldDescriptor jdoFieldDesc = (JDOFieldDescriptor)fieldDesc;
            this._tableName = classTable;
            this._store = !ext && !jdoFieldDesc.isReadonly();
            this._multi = false;
            this._joined = false;
            this._joinFields = null;
            this._dirtyCheck = jdoFieldDesc.isDirtyCheck();
            this._columns = new SQLColumnInfo[1];
            String sqlName = jdoFieldDesc.getFieldName();
            if (jdoFieldDesc.getSQLName() != null) {
                sqlName = jdoFieldDesc.getSQLName()[0];
            }
            FieldHandlerImpl fh = (FieldHandlerImpl)jdoFieldDesc.getHandler();
            this._columns[0] = new SQLColumnInfo(sqlName, jdoFieldDesc.getSQLType()[0], fh.getConvertTo(), fh.getConvertFrom(), fh.getConvertParam());
        }
    }

    public String getTableName() {
        return this._tableName;
    }

    public boolean isStore() {
        return this._store;
    }

    public boolean isMulti() {
        return this._multi;
    }

    public boolean isJoined() {
        return this._joined;
    }

    public boolean isDirtyCheck() {
        return this._dirtyCheck;
    }

    public String[] getJoinFields() {
        return this._joinFields;
    }

    public SQLColumnInfo[] getColumnInfo() {
        return this._columns;
    }

    public FieldDescriptor getFieldDescriptor() {
        return this._fieldDescriptor;
    }

    public String toString() {
        return this._tableName + "." + this._fieldDescriptor.getFieldName();
    }
}

