/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.logging.Level;
import javax.measure.Unit;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.GridCacheValue;
import org.apache.sis.internal.netcdf.Linearizer;
import org.apache.sis.internal.netcdf.NamedElement;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.referencing.EllipsoidalHeightCombiner;
import org.apache.sis.internal.referencing.ReferencingFactoryContainer;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.TemporalUtilities;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.DefaultGeocentricCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

abstract class CRSBuilder<D extends Datum, CS extends CoordinateSystem> {
    private final Class<D> datumType;
    private final String datumBase;
    private final byte datumIndex;
    private final byte minDim;
    private final byte maxDim;
    private byte dimension;
    private Axis[] axes;
    protected D datum;
    protected CS coordinateSystem;
    protected SingleCRS referenceSystem;
    private FactoryException warnings;
    static final int DATUM_CACHE_SIZE = 4;

    private CRSBuilder(Class<D> clazz, String string, byte by, byte by2, byte by3) {
        this.datumType = clazz;
        this.datumBase = string;
        this.datumIndex = by;
        this.minDim = by2;
        this.maxDim = by3;
        this.axes = new Axis[3];
    }

    public static CoordinateReferenceSystem assemble(Decoder decoder, Grid grid, List<GridCacheValue> list, Matrix matrix) throws DataStoreException, FactoryException, IOException {
        ArrayList arrayList = new ArrayList(4);
        for (Axis axis : grid.getAxes(decoder)) {
            CRSBuilder.dispatch(arrayList, axis);
        }
        Axis[] axisArray = new SingleCRS[arrayList.size()];
        for (int i = 0; i < axisArray.length; ++i) {
            axisArray[i] = ((CRSBuilder)arrayList.get(i)).build(decoder, true);
        }
        if (list != null && !list.isEmpty()) {
            Linearizer.replaceInCompoundCRS((SingleCRS[])axisArray, list, matrix);
        }
        switch (axisArray.length) {
            case 0: {
                return null;
            }
            case 1: {
                return axisArray[0];
            }
        }
        return new EllipsoidalHeightCombiner((ReferencingFactoryContainer)decoder).createCompoundCRS(CRSBuilder.properties(grid.getName()), (CoordinateReferenceSystem[])axisArray);
    }

    static CoordinateReferenceSystem assemble(Decoder decoder, Iterable<Variable> iterable, SingleCRS[] singleCRSArray) throws DataStoreException, FactoryException, IOException {
        ArrayList arrayList = new ArrayList(4);
        for (Variable variable : iterable) {
            CRSBuilder.dispatch(arrayList, new Axis(variable));
        }
        Object[] objectArray = new SingleCRS[arrayList.size()];
        int n = 0;
        for (CRSBuilder cRSBuilder : arrayList) {
            SingleCRS singleCRS = cRSBuilder.build(decoder, false);
            if (cRSBuilder instanceof Temporal) {
                singleCRSArray[0] = singleCRS;
                continue;
            }
            objectArray[n++] = singleCRS;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return objectArray[0];
            }
        }
        return new EllipsoidalHeightCombiner((ReferencingFactoryContainer)decoder).createCompoundCRS((CoordinateReferenceSystem[])ArraysExt.resize((Object[])objectArray, (int)n));
    }

    private static void dispatch(List<CRSBuilder<?, ?>> list, Axis axis) throws DataStoreContentException {
        Supplier<CRSBuilder> supplier;
        Class clazz;
        int n;
        int n2 = -1;
        switch (axis.abbreviation) {
            case 'h': {
                n = list.size();
                while (--n >= 0) {
                    if (!(list.get(n) instanceof Projected)) continue;
                    n2 = n;
                    break;
                }
            }
            case '\u03bb': 
            case '\u03c6': {
                clazz = Geographic.class;
                supplier = Geographic::new;
                break;
            }
            case 'r': 
            case '\u03a9': 
            case '\u03b8': {
                clazz = Spherical.class;
                supplier = Spherical::new;
                break;
            }
            case 'E': 
            case 'N': {
                clazz = Projected.class;
                supplier = Projected::new;
                break;
            }
            case 'D': 
            case 'H': {
                clazz = Vertical.class;
                supplier = Vertical::new;
                break;
            }
            case 't': {
                clazz = Temporal.class;
                supplier = Temporal::new;
                break;
            }
            default: {
                clazz = Engineering.class;
                supplier = Engineering::new;
            }
        }
        n = list.size();
        while (--n >= 0) {
            CRSBuilder<?, ?> cRSBuilder = list.get(n);
            if (!clazz.isInstance(cRSBuilder) && n != n2) continue;
            super.add(axis);
            return;
        }
        CRSBuilder cRSBuilder = supplier.get();
        if (clazz == Projected.class) {
            int n3 = list.size();
            block10: while (--n3 >= 0) {
                CRSBuilder<?, ?> cRSBuilder2 = list.get(n3);
                for (Axis axis2 : cRSBuilder2.axes) {
                    if (axis2.abbreviation != 'h') continue block10;
                }
                for (Axis axis2 : cRSBuilder2.axes) {
                    cRSBuilder.add(axis2);
                }
                list.remove(n3);
                break;
            }
        }
        cRSBuilder.add(axis);
        list.add(cRSBuilder);
    }

    private void add(Axis axis) throws DataStoreContentException {
        if (this.dimension == 127) {
            throw new DataStoreContentException(this.getFirstAxis().coordinates.errors().getString((short)36, (Object)"axes", (Object)128));
        }
        if (this.dimension >= this.axes.length) {
            this.axes = Arrays.copyOf(this.axes, this.dimension * 2);
        }
        byte by = this.dimension;
        this.dimension = (byte)(by + 1);
        this.axes[by] = axis;
    }

    final boolean is3D() {
        return this.dimension >= 3;
    }

    final Axis getFirstAxis() {
        return this.axes[0];
    }

    private SingleCRS build(Decoder decoder, boolean bl) throws FactoryException, DataStoreException, IOException {
        NumberRange numberRange;
        CSFactory cSFactory;
        Object object;
        if (this.dimension < this.minDim || this.dimension > this.maxDim) {
            Variable variable = this.getFirstAxis().coordinates;
            throw new DataStoreContentException(variable.resources().getString((short)10, variable.getFilename(), this.getClass().getSimpleName(), this.dimension, NamedElement.listNames(this.axes, this.dimension, ", ")));
        }
        this.datum = (Datum)this.datumType.cast(decoder.datumCache[this.datumIndex]);
        this.setPredefinedComponents(decoder);
        if (this.datum == null) {
            this.createDatum(decoder.getDatumFactory(), CRSBuilder.properties("Unknown datum presumably based upon ".concat(this.datumBase)));
        }
        decoder.datumCache[this.datumIndex] = this.datum;
        if (this.coordinateSystem != null) {
            int n = this.dimension;
            while (--n >= 0) {
                object = this.axes[n];
                if (object != null && ((Axis)object).isSameUnitAndDirection(this.coordinateSystem.getAxis(n))) continue;
                this.coordinateSystem = null;
                this.referenceSystem = null;
                break;
            }
        }
        if (this.referenceSystem == null) {
            Map<String, ?> map;
            if (this.coordinateSystem == null) {
                object = new StringJoiner(" ");
                cSFactory = decoder.getCSFactory();
                numberRange = new CoordinateSystemAxis[this.dimension];
                for (int i = 0; i < ((CoordinateSystemAxis[])numberRange).length; ++i) {
                    Axis axis = this.axes[i];
                    ((StringJoiner)object).add(axis.getName());
                    numberRange[i] = axis.toISO(cSFactory, i, bl);
                }
                this.createCS(cSFactory, CRSBuilder.properties(((StringJoiner)object).toString()), (CoordinateSystemAxis[])numberRange);
                map = CRSBuilder.properties(this.coordinateSystem.getName());
            } else {
                map = CRSBuilder.properties(NamedElement.listNames(this.axes, this.dimension, " "));
            }
            this.createCRS(decoder.getCRSFactory(), map);
        }
        if (bl) {
            CoordinateSystem coordinateSystem = this.referenceSystem.getCoordinateSystem();
            int n = coordinateSystem.getDimension();
            while (--n >= 0) {
                cSFactory = coordinateSystem.getAxis(n);
                if (!RangeMeaning.WRAPAROUND.equals((Object)cSFactory.getRangeMeaning()) || (numberRange = this.axes[n].read().range()) == null || !(numberRange.getMinDouble() >= 0.0) || !(numberRange.getMaxDouble() > cSFactory.getMaximumValue())) continue;
                this.referenceSystem = (SingleCRS)AbstractCRS.castOrCopy((CoordinateReferenceSystem)this.referenceSystem).forConvention(AxesConvention.POSITIVE_RANGE);
                break;
            }
        }
        if (this.warnings != null) {
            decoder.listeners.warning(Level.FINE, null, (Exception)((Object)this.warnings));
        }
        return this.referenceSystem;
    }

    final void recoverableException(FactoryException factoryException) {
        if (this.warnings == null) {
            this.warnings = factoryException;
        } else {
            this.warnings.addSuppressed((Throwable)factoryException);
        }
    }

    private static Map<String, ?> properties(Object object) {
        return Collections.singletonMap("name", object);
    }

    final Integer epsgCandidateCS(Unit<?> unit) {
        Unit<?> unit2 = this.getFirstAxis().getUnit();
        if (unit2 == null) {
            unit2 = unit;
        }
        AxisDirection[] axisDirectionArray = new AxisDirection[this.dimension];
        for (int i = 0; i < axisDirectionArray.length; ++i) {
            axisDirectionArray[i] = this.axes[i].direction;
        }
        return CoordinateSystems.getEpsgCode(unit2, (AxisDirection[])axisDirectionArray);
    }

    abstract void setPredefinedComponents(Decoder var1) throws FactoryException;

    abstract void createDatum(DatumFactory var1, Map<String, ?> var2) throws FactoryException;

    abstract void createCS(CSFactory var1, Map<String, ?> var2, CoordinateSystemAxis[] var3) throws FactoryException;

    abstract void createCRS(CRSFactory var1, Map<String, ?> var2) throws FactoryException;

    private static final class Temporal
    extends CRSBuilder<TemporalDatum, TimeCS> {
        public Temporal() {
            super(TemporalDatum.class, "", (byte)2, (byte)1, (byte)1);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) {
            CommonCRS.Temporal temporal;
            Axis axis = this.getFirstAxis();
            Unit<?> unit = axis.getUnit();
            if (Units.DAY.equals(unit)) {
                temporal = CommonCRS.Temporal.JULIAN;
            } else if (Units.SECOND.equals(unit)) {
                temporal = CommonCRS.Temporal.UNIX;
            } else if (Units.MILLISECOND.equals(unit)) {
                temporal = CommonCRS.Temporal.JAVA;
            } else {
                return;
            }
            this.coordinateSystem = temporal.crs().getCoordinateSystem();
        }

        @Override
        void createDatum(DatumFactory datumFactory, Map<String, ?> map) throws FactoryException {
            Axis axis = this.getFirstAxis();
            axis.getUnit();
            Instant instant = axis.coordinates.epoch;
            if (instant != null) {
                CommonCRS.Temporal temporal = CommonCRS.Temporal.forEpoch((Instant)instant);
                if (temporal != null) {
                    this.datum = temporal.datum();
                } else {
                    map = CRSBuilder.properties("Time since " + instant);
                    this.datum = datumFactory.createTemporalDatum(map, TemporalUtilities.toDate((Instant)instant));
                }
            }
        }

        @Override
        void createCS(CSFactory cSFactory, Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) throws FactoryException {
            this.coordinateSystem = cSFactory.createTimeCS(map, coordinateSystemAxisArray[0]);
        }

        @Override
        void createCRS(CRSFactory cRSFactory, Map<String, ?> map) throws FactoryException {
            map = CRSBuilder.properties(this.getFirstAxis().coordinates.getUnitsString());
            this.referenceSystem = this.datum != null ? cRSFactory.createTemporalCRS(map, (TemporalDatum)this.datum, (TimeCS)this.coordinateSystem) : cRSFactory.createEngineeringCRS(map, CommonCRS.Engineering.TIME.datum(), this.coordinateSystem);
        }
    }

    private static final class Projected
    extends Geodetic<CartesianCS> {
        private CommonCRS sphericalDatum;
        private static final Conversion UNKNOWN_PROJECTION;

        public Projected() {
            super((byte)2);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) throws FactoryException {
            super.setPredefinedComponents(decoder);
            this.sphericalDatum = decoder.convention().defaultHorizontalCRS(true);
            this.datum = this.sphericalDatum.datum();
            if (this.isPredefinedCS(Units.METRE)) {
                this.coordinateSystem = decoder.getStandardProjectedCS();
            }
        }

        @Override
        void createCS(CSFactory cSFactory, Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) throws FactoryException {
            this.coordinateSystem = coordinateSystemAxisArray.length > 2 ? cSFactory.createCartesianCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]) : cSFactory.createCartesianCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
        }

        @Override
        void createCRS(CRSFactory cRSFactory, Map<String, ?> map) throws FactoryException {
            GeographicCRS geographicCRS;
            boolean bl = ((CartesianCS)this.coordinateSystem).getDimension() >= 3;
            GeographicCRS geographicCRS2 = geographicCRS = bl ? this.sphericalDatum.geographic3D() : this.sphericalDatum.geographic();
            if (!geographicCRS.getDatum().equals(this.datum)) {
                geographicCRS = cRSFactory.createGeographicCRS(map, (GeodeticDatum)this.datum, geographicCRS.getCoordinateSystem());
            }
            this.referenceSystem = cRSFactory.createProjectedCRS(map, geographicCRS, UNKNOWN_PROJECTION, (CartesianCS)this.coordinateSystem);
        }

        static {
            DefaultCoordinateOperationFactory defaultCoordinateOperationFactory = (DefaultCoordinateOperationFactory)DefaultFactories.forBuildin(CoordinateOperationFactory.class, DefaultCoordinateOperationFactory.class);
            try {
                OperationMethod operationMethod = defaultCoordinateOperationFactory.getOperationMethod("Equidistant Cylindrical (Spherical)");
                UNKNOWN_PROJECTION = defaultCoordinateOperationFactory.createDefiningConversion(CRSBuilder.properties("Not specified (presumed Plate Carr\u00e9e)"), operationMethod, operationMethod.getParameters().createValue());
            }
            catch (FactoryException factoryException) {
                throw new ExceptionInInitializerError(factoryException);
            }
        }
    }

    private static final class Geographic
    extends Geodetic<EllipsoidalCS> {
        public Geographic() {
            super((byte)2);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) throws FactoryException {
            super.setPredefinedComponents(decoder);
            if (this.isPredefinedCS(Units.DEGREE)) {
                GeographicCRS geographicCRS;
                if (this.is3D()) {
                    geographicCRS = this.defaultCRS.geographic3D();
                    if (this.isLongitudeFirst) {
                        geographicCRS = DefaultGeographicCRS.castOrCopy((GeographicCRS)geographicCRS).forConvention(AxesConvention.RIGHT_HANDED);
                    }
                } else {
                    geographicCRS = this.isLongitudeFirst ? this.defaultCRS.normalizedGeographic() : this.defaultCRS.geographic();
                }
                this.referenceSystem = geographicCRS;
                this.coordinateSystem = geographicCRS.getCoordinateSystem();
                this.datum = geographicCRS.getDatum();
            } else {
                this.datum = this.defaultCRS.datum();
                Integer n = this.epsgCandidateCS(Units.DEGREE);
                if (n != null) {
                    try {
                        this.coordinateSystem = decoder.getCSAuthorityFactory().createEllipsoidalCS(n.toString());
                    }
                    catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                        this.recoverableException((FactoryException)((Object)noSuchAuthorityCodeException));
                    }
                }
            }
        }

        @Override
        void createCS(CSFactory cSFactory, Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) throws FactoryException {
            this.coordinateSystem = coordinateSystemAxisArray.length > 2 ? cSFactory.createEllipsoidalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]) : cSFactory.createEllipsoidalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
        }

        @Override
        void createCRS(CRSFactory cRSFactory, Map<String, ?> map) throws FactoryException {
            this.referenceSystem = cRSFactory.createGeographicCRS(map, (GeodeticDatum)this.datum, (EllipsoidalCS)this.coordinateSystem);
        }
    }

    private static final class Spherical
    extends Geodetic<SphericalCS> {
        public Spherical() {
            super((byte)3);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) throws FactoryException {
            super.setPredefinedComponents(decoder);
            if (this.isPredefinedCS(Units.DEGREE)) {
                GeocentricCRS geocentricCRS = this.defaultCRS.spherical();
                if (this.isLongitudeFirst) {
                    geocentricCRS = DefaultGeocentricCRS.castOrCopy((GeocentricCRS)geocentricCRS).forConvention(AxesConvention.RIGHT_HANDED);
                }
                this.referenceSystem = geocentricCRS;
                this.coordinateSystem = (SphericalCS)geocentricCRS.getCoordinateSystem();
                this.datum = geocentricCRS.getDatum();
            } else {
                this.datum = this.defaultCRS.datum();
            }
        }

        @Override
        void createCS(CSFactory cSFactory, Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) throws FactoryException {
            this.coordinateSystem = cSFactory.createSphericalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
        }

        @Override
        void createCRS(CRSFactory cRSFactory, Map<String, ?> map) throws FactoryException {
            this.referenceSystem = cRSFactory.createGeocentricCRS(map, (GeodeticDatum)this.datum, (SphericalCS)this.coordinateSystem);
        }
    }

    private static final class Vertical
    extends CRSBuilder<VerticalDatum, VerticalCS> {
        public Vertical() {
            super(VerticalDatum.class, "Mean Sea Level", (byte)1, (byte)1, (byte)1);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) {
            CommonCRS.Vertical vertical;
            Axis axis = this.getFirstAxis();
            Unit<?> unit = axis.getUnit();
            if (Units.METRE.equals(unit)) {
                vertical = AxisDirection.UP.equals((Object)axis.direction) ? CommonCRS.Vertical.MEAN_SEA_LEVEL : CommonCRS.Vertical.DEPTH;
            } else if (Units.HECTOPASCAL.equals(unit)) {
                vertical = CommonCRS.Vertical.BAROMETRIC;
            } else {
                return;
            }
            this.coordinateSystem = vertical.crs().getCoordinateSystem();
        }

        @Override
        void createDatum(DatumFactory datumFactory, Map<String, ?> map) throws FactoryException {
            this.datum = datumFactory.createVerticalDatum(map, VerticalDatumType.GEOIDAL);
        }

        @Override
        void createCS(CSFactory cSFactory, Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) throws FactoryException {
            this.coordinateSystem = cSFactory.createVerticalCS(map, coordinateSystemAxisArray[0]);
        }

        @Override
        void createCRS(CRSFactory cRSFactory, Map<String, ?> map) throws FactoryException {
            this.referenceSystem = cRSFactory.createVerticalCRS(map, (VerticalDatum)this.datum, (VerticalCS)this.coordinateSystem);
        }
    }

    private static final class Engineering
    extends CRSBuilder<EngineeringDatum, CoordinateSystem> {
        public Engineering() {
            super(EngineeringDatum.class, "affine coordinate system", (byte)3, (byte)2, (byte)3);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) {
        }

        @Override
        void createDatum(DatumFactory datumFactory, Map<String, ?> map) throws FactoryException {
            this.datum = datumFactory.createEngineeringDatum(map);
        }

        @Override
        void createCS(CSFactory cSFactory, Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) throws FactoryException {
            try {
                this.coordinateSystem = coordinateSystemAxisArray.length > 2 ? cSFactory.createAffineCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]) : cSFactory.createAffineCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
            }
            catch (InvalidGeodeticParameterException invalidGeodeticParameterException) {
                this.coordinateSystem = new AbstractCS(map, coordinateSystemAxisArray);
                this.recoverableException((FactoryException)((Object)invalidGeodeticParameterException));
            }
        }

        @Override
        void createCRS(CRSFactory cRSFactory, Map<String, ?> map) throws FactoryException {
            this.referenceSystem = cRSFactory.createEngineeringCRS(map, (EngineeringDatum)this.datum, this.coordinateSystem);
        }
    }

    private static abstract class Geodetic<CS extends CoordinateSystem>
    extends CRSBuilder<GeodeticDatum, CS> {
        protected CommonCRS defaultCRS;
        protected boolean isLongitudeFirst;

        Geodetic(byte by) {
            super(GeodeticDatum.class, "GRS 1980", (byte)0, by, (byte)3);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) throws FactoryException {
            this.defaultCRS = decoder.convention().defaultHorizontalCRS(false);
        }

        @Override
        final void createDatum(DatumFactory datumFactory, Map<String, ?> map) throws FactoryException {
            GeodeticDatum geodeticDatum = this.defaultCRS.datum();
            this.datum = datumFactory.createGeodeticDatum(map, geodeticDatum.getEllipsoid(), geodeticDatum.getPrimeMeridian());
        }

        final boolean isPredefinedCS(Unit<?> unit) {
            Axis axis = this.getFirstAxis();
            Unit<?> unit2 = axis.getUnit();
            if (unit2 == null || unit.equals(unit2)) {
                this.isLongitudeFirst = AxisDirection.EAST.equals((Object)axis.direction);
                if (this.isLongitudeFirst || AxisDirection.NORTH.equals((Object)axis.direction)) {
                    return true;
                }
            }
            return false;
        }
    }
}

