"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.window = void 0;
const chai_1 = require("chai");
const mocha_1 = require("mocha");
const mona_dish_1 = require("mona-dish");
var equalsIgnoreCase = mona_dish_1.Lang.equalsIgnoreCase;
var assertType = mona_dish_1.Lang.assertType;
var objToArray = mona_dish_1.Lang.objToArray;
var isFunc = mona_dish_1.Lang.isFunc;
var isString = mona_dish_1.Lang.isString;
var trim = mona_dish_1.Lang.trim;
var strToArray = mona_dish_1.Lang.strToArray;
const Lang_1 = require("../../impl/util/Lang");
var keyValToStr = Lang_1.ExtLang.keyValToStr;
const jsdom = require("jsdom");
const { JSDOM } = jsdom;
const dom = new JSDOM(`
    <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Title</title>
    </head>
    <body>
        <div />
        <div />
        <div />
        <div />
    </body>
    </html>
    
    `);
exports.window = dom.window;
function hello_world() {
    return "Hello World!";
}
(0, mocha_1.describe)('Hello World!', () => {
    before(() => {
        global.window = exports.window;
        global.document = exports.window.document;
        global.navigator = {
            language: "en-En"
        };
    });
    (0, mocha_1.it)('first test', () => {
        const result = hello_world();
        (0, chai_1.expect)(result).to.equal('Hello World!');
    });
});
class Probe {
    constructor() {
        this.val1 = 1;
        this.val2 = 2;
        this.val3 = 3;
    }
}
(0, mocha_1.describe)('Lang tests', () => {
    (0, mocha_1.it)('initializable', () => {
        const lang = mona_dish_1.Lang;
        (0, chai_1.expect)(lang).to.exist;
    });
    (0, mocha_1.it)('strToArray working', () => {
        let arr = strToArray("hello.world.from.me", /\./gi);
        (0, chai_1.expect)(arr).to.exist;
        (0, chai_1.expect)(arr.length).to.eq(4);
        (0, chai_1.expect)(arr[3]).to.eq("me");
    });
    (0, mocha_1.it)('trim working', () => {
        let origStr = " hello world from me    ";
        let trimmed = trim(origStr);
        (0, chai_1.expect)(trimmed).to.exist;
        (0, chai_1.expect)(trimmed).to.eq("hello world from me");
    });
    (0, mocha_1.it)('isString working', () => {
        (0, chai_1.expect)(isString(" ")).to.be.true;
        (0, chai_1.expect)(isString('')).to.be.true;
        (0, chai_1.expect)(isString(null)).to.be.false;
        (0, chai_1.expect)(isString(undefined)).to.be.false;
        (0, chai_1.expect)(isString(function () {
            return true;
        })).to.be.false;
        (0, chai_1.expect)(isString(new Probe())).to.be.false;
    });
    (0, mocha_1.it)('isFunc working', () => {
        (0, chai_1.expect)(isFunc(() => {
        })).to.be.true;
        (0, chai_1.expect)(isFunc(function () {
            return true;
        })).to.be.true;
        (0, chai_1.expect)(isFunc("blarg")).to.be.false;
        (0, chai_1.expect)(isFunc(new Probe())).to.be.false;
    });
    (0, mocha_1.it)('objToArray working', () => {
        let obj_probe = new Probe();
        let resultArr = objToArray(obj_probe);
        (0, chai_1.expect)(assertType(resultArr, Array)).to.be.true;
        (0, chai_1.expect)(resultArr.length).to.eq(0);
        obj_probe = exports.window.document.body.querySelectorAll("div");
        resultArr = objToArray(obj_probe);
        (0, chai_1.expect)(resultArr.length).to.eq(4);
        (0, chai_1.expect)(assertType(resultArr, Array)).to.be.true;
    });
    (0, mocha_1.it)('keyval to string working', () => {
        let keyval = keyValToStr("key", "val", ":");
        (0, chai_1.expect)(keyval).to.eq("key:val");
    });
    (0, mocha_1.it)('equals ignore case test', () => {
        (0, chai_1.expect)(equalsIgnoreCase(null, null)).to.be.true;
        (0, chai_1.expect)(equalsIgnoreCase("", "")).to.be.true;
        (0, chai_1.expect)(equalsIgnoreCase("null", "NuLL")).to.be.true;
        (0, chai_1.expect)(equalsIgnoreCase("null ", "NuLL")).to.be.false;
        (0, chai_1.expect)(equalsIgnoreCase("null", "NuLL2")).to.be.false;
    });
    /*it('form data test', () => {
        const lang = Lang;
        let sourceData: any = [1, 2, 3];
        let formData: FormDataDecorator = createFormDataDecorator(sourceData);
        expect(formData instanceof FormDataDecorator).to.be.true;
        expect(formData.makeFinal()).to.eq("1&2&3");

        formData.append("bla", "arg");
        expect(formData.makeFinal()).to.eq("1&2&3&bla=arg");
    });*/
});
//# sourceMappingURL=LangTest.spec.js.map