/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import java.lang.annotation.ElementType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.bval.jsr.ConstraintViolationImpl;
import org.apache.bval.jsr.GroupValidationContext;
import org.apache.bval.jsr.util.PathImpl;
import org.apache.bval.model.ValidationContext;
import org.apache.bval.model.ValidationListener;

public final class ConstraintValidationListener<T>
implements ValidationListener {
    private final Set<ConstraintViolation<T>> constraintViolations = new HashSet<ConstraintViolation<T>>();
    private final T rootBean;
    private final Class<T> rootBeanType;
    private int compositeDepth = 0;
    private boolean hasCompositeError;

    public ConstraintValidationListener(T aRootBean, Class<T> rootBeanType) {
        this.rootBean = aRootBean;
        this.rootBeanType = rootBeanType;
    }

    public <VL extends ValidationListener> void addError(String reason, ValidationContext<VL> context) {
        this.addError(reason, null, context);
    }

    public <VL extends ValidationListener> void addError(ValidationListener.Error error, ValidationContext<VL> context) {
        if (error.getOwner() instanceof Path) {
            this.addError(error.getReason(), (Path)error.getOwner(), context);
        } else {
            this.addError(error.getReason(), null, context);
        }
    }

    private void addError(String messageTemplate, Path propPath, ValidationContext<?> context) {
        Object[] parameters;
        Object leaf;
        Object rootBean;
        Object returnValue;
        ElementType elementType;
        ConstraintDescriptor<?> descriptor;
        String message;
        Object value;
        if (this.compositeDepth > 0) {
            this.hasCompositeError |= true;
            return;
        }
        if (context instanceof GroupValidationContext) {
            GroupValidationContext gcontext = (GroupValidationContext)context;
            value = gcontext.getValidatedValue();
            message = gcontext instanceof MessageInterpolator.Context ? gcontext.getMessageResolver().interpolate(messageTemplate, (MessageInterpolator.Context)((Object)gcontext)) : gcontext.getMessageResolver().interpolate(messageTemplate, null);
            descriptor = gcontext.getConstraintValidation().asSerializableDescriptor();
            if (propPath == null) {
                propPath = gcontext.getPropertyPath();
            }
        } else {
            value = context.getMetaProperty() == null ? context.getBean() : context.getPropertyValue();
            message = messageTemplate;
            if (propPath == null) {
                propPath = PathImpl.createPathFromString(context.getPropertyName());
            }
            descriptor = null;
        }
        ElementType elementType2 = elementType = context.getAccess() != null ? context.getAccess().getElementType() : null;
        if (GroupValidationContext.class.isInstance(context)) {
            GroupValidationContext ctx = (GroupValidationContext)GroupValidationContext.class.cast(context);
            ElementKind elementKind = ctx.getElementKind();
            Iterator it = propPath.iterator();
            ElementKind kind = ((Path.Node)propPath.iterator().next()).getKind();
            returnValue = ctx.getReturnValue();
            if (ElementKind.CONSTRUCTOR.equals((Object)kind)) {
                rootBean = null;
                leaf = context.getBean();
                returnValue = this.rootBean;
            } else if (ElementKind.METHOD.equals((Object)kind)) {
                if (ElementKind.RETURN_VALUE.equals((Object)elementKind)) {
                    rootBean = returnValue;
                    if (ConstraintValidationListener.kindOf(propPath, ElementKind.RETURN_VALUE)) {
                        leaf = returnValue;
                        returnValue = this.rootBean;
                    } else {
                        leaf = this.rootBean;
                        returnValue = this.rootBean;
                    }
                } else {
                    rootBean = this.rootBean;
                    leaf = ConstraintValidationListener.kindOf(propPath, ElementKind.PARAMETER, ElementKind.CROSS_PARAMETER) ? rootBean : context.getBean();
                }
            } else {
                rootBean = this.rootBean;
                leaf = context.getBean();
            }
            if (ElementKind.CONSTRUCTOR.equals((Object)kind) && (ElementKind.CROSS_PARAMETER.equals((Object)elementKind) || ElementKind.PARAMETER.equals((Object)elementKind)) && it.hasNext() && it.next() != null && it.hasNext() && it.next() != null && !it.hasNext()) {
                leaf = null;
            }
            parameters = ctx.getParameters();
        } else {
            leaf = context.getBean();
            returnValue = null;
            parameters = null;
            rootBean = this.rootBean;
        }
        this.constraintViolations.add(new ConstraintViolationImpl<T>(messageTemplate, message, rootBean, leaf, propPath, value, descriptor, this.rootBeanType, elementType, returnValue, parameters));
    }

    private static boolean kindOf(Path propPath, ElementKind ... kinds) {
        Iterator node = propPath.iterator();
        boolean isParam = false;
        block0: while (node.hasNext()) {
            ElementKind current = ((Path.Node)node.next()).getKind();
            isParam = false;
            for (ElementKind k : kinds) {
                if (!k.equals((Object)current)) continue;
                isParam = true;
                continue block0;
            }
        }
        return isParam;
    }

    public Set<ConstraintViolation<T>> getConstraintViolations() {
        return this.constraintViolations;
    }

    public boolean isEmpty() {
        return this.constraintViolations.isEmpty();
    }

    public T getRootBean() {
        return this.rootBean;
    }

    public Class<T> getRootBeanType() {
        return this.rootBeanType;
    }

    public int violationsSize() {
        return this.constraintViolations.size();
    }

    public boolean hasViolations() {
        return this.compositeDepth == 0 ? !this.constraintViolations.isEmpty() : this.hasCompositeError;
    }

    public boolean beginReportAsSingle() {
        return ++this.compositeDepth == 1;
    }

    public boolean endReportAsSingle() {
        boolean endOutMostReportAsSingle;
        boolean bl = endOutMostReportAsSingle = --this.compositeDepth == 0;
        if (endOutMostReportAsSingle) {
            this.hasCompositeError = false;
        }
        return endOutMostReportAsSingle;
    }
}

