/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.message;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.message.MessageId;
import org.apache.rocketmq.client.apis.message.MessageView;
import org.apache.rocketmq.client.java.message.GeneralMessage;
import org.apache.rocketmq.client.java.message.MessageImpl;
import org.apache.rocketmq.client.java.message.MessageViewImpl;

public class GeneralMessageImpl
implements GeneralMessage {
    private final String topic;
    private final MessageId messageId;
    private final byte[] body;
    private final Map<String, String> properties;
    private final String tag;
    private final Collection<String> keys;
    private final String messageGroup;
    private final Long deliveryTimestamp;
    private final String bornHost;
    private final String parentTraceContext;
    private final String traceContext;
    private final Long bornTimestamp;
    private final Integer deliveryAttempt;
    private final Long decodeTimestamp;
    private final Long transportDeliveryTimestamp;

    public GeneralMessageImpl(Message message) {
        this.topic = message.getTopic();
        this.messageId = null;
        if (message instanceof MessageImpl) {
            MessageImpl impl = (MessageImpl)message;
            this.body = impl.body;
        } else {
            ByteBuffer byteBuffer = message.getBody();
            this.body = new byte[byteBuffer.remaining()];
            byteBuffer.get(this.body);
        }
        this.properties = message.getProperties();
        this.tag = message.getTag().orElse(null);
        this.keys = message.getKeys();
        this.messageGroup = message.getMessageGroup().orElse(null);
        this.deliveryTimestamp = message.getDeliveryTimestamp().orElse(null);
        this.bornHost = null;
        this.parentTraceContext = message.getParentTraceContext().orElse(null);
        this.traceContext = null;
        this.bornTimestamp = null;
        this.deliveryAttempt = null;
        this.decodeTimestamp = null;
        this.transportDeliveryTimestamp = null;
    }

    public GeneralMessageImpl(MessageView message) {
        Long messageTransportDeliveryTimestamp;
        Long messageDecodeTimestamp;
        String messageTraceContext;
        byte[] messageBody;
        this.topic = message.getTopic();
        this.messageId = message.getMessageId();
        if (message instanceof MessageViewImpl) {
            MessageViewImpl impl = (MessageViewImpl)message;
            messageBody = impl.body;
            messageTraceContext = impl.getTraceContext().orElse(null);
            messageDecodeTimestamp = impl.getDecodeTimestamp();
            messageTransportDeliveryTimestamp = impl.getTransportDeliveryTimestamp().orElse(null);
        } else {
            ByteBuffer byteBuffer = message.getBody();
            messageBody = new byte[byteBuffer.remaining()];
            byteBuffer.get(messageBody);
            messageTraceContext = null;
            messageDecodeTimestamp = null;
            messageTransportDeliveryTimestamp = null;
        }
        this.body = messageBody;
        this.properties = message.getProperties();
        this.tag = message.getTag().orElse(null);
        this.keys = message.getKeys();
        this.messageGroup = message.getMessageGroup().orElse(null);
        this.deliveryTimestamp = message.getDeliveryTimestamp().orElse(null);
        this.bornHost = message.getBornHost();
        this.parentTraceContext = null;
        this.traceContext = messageTraceContext;
        this.bornTimestamp = message.getBornTimestamp();
        this.deliveryAttempt = message.getDeliveryAttempt();
        this.decodeTimestamp = messageDecodeTimestamp;
        this.transportDeliveryTimestamp = messageTransportDeliveryTimestamp;
    }

    @Override
    public Optional<MessageId> getMessageId() {
        return Optional.ofNullable(this.messageId);
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public ByteBuffer getBody() {
        return ByteBuffer.wrap(this.body).asReadOnlyBuffer();
    }

    @Override
    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }

    @Override
    public Optional<String> getTag() {
        return Optional.ofNullable(this.tag);
    }

    @Override
    public Collection<String> getKeys() {
        return new ArrayList<String>(this.keys);
    }

    @Override
    public Optional<String> getMessageGroup() {
        return Optional.ofNullable(this.messageGroup);
    }

    @Override
    public Optional<String> getParentTraceContext() {
        return Optional.ofNullable(this.parentTraceContext);
    }

    @Override
    public Optional<String> getTraceContext() {
        return Optional.ofNullable(this.traceContext);
    }

    @Override
    public Optional<Long> getDeliveryTimestamp() {
        return Optional.ofNullable(this.deliveryTimestamp);
    }

    @Override
    public Optional<String> getBornHost() {
        return Optional.ofNullable(this.bornHost);
    }

    @Override
    public Optional<Long> getBornTimestamp() {
        return Optional.ofNullable(this.bornTimestamp);
    }

    @Override
    public Optional<Integer> getDeliveryAttempt() {
        return Optional.ofNullable(this.deliveryAttempt);
    }

    @Override
    public Optional<Long> getDecodeTimestamp() {
        return Optional.ofNullable(this.decodeTimestamp);
    }

    @Override
    public Optional<Long> getTransportDeliveryTimestamp() {
        return Optional.ofNullable(this.transportDeliveryTimestamp);
    }
}

