/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.rpc;

import apache.rocketmq.v2.AckMessageRequest;
import apache.rocketmq.v2.AckMessageResponse;
import apache.rocketmq.v2.ChangeInvisibleDurationRequest;
import apache.rocketmq.v2.ChangeInvisibleDurationResponse;
import apache.rocketmq.v2.EndTransactionRequest;
import apache.rocketmq.v2.EndTransactionResponse;
import apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest;
import apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse;
import apache.rocketmq.v2.HeartbeatRequest;
import apache.rocketmq.v2.HeartbeatResponse;
import apache.rocketmq.v2.MessagingServiceGrpc;
import apache.rocketmq.v2.NotifyClientTerminationRequest;
import apache.rocketmq.v2.NotifyClientTerminationResponse;
import apache.rocketmq.v2.QueryAssignmentRequest;
import apache.rocketmq.v2.QueryAssignmentResponse;
import apache.rocketmq.v2.QueryRouteRequest;
import apache.rocketmq.v2.QueryRouteResponse;
import apache.rocketmq.v2.ReceiveMessageRequest;
import apache.rocketmq.v2.ReceiveMessageResponse;
import apache.rocketmq.v2.SendMessageRequest;
import apache.rocketmq.v2.SendMessageResponse;
import apache.rocketmq.v2.TelemetryCommand;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.NameResolver;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.rpc.IpNameResolverFactory;
import org.apache.rocketmq.client.java.rpc.LoggingInterceptor;
import org.apache.rocketmq.client.java.rpc.RpcClient;

public class RpcClientImpl
implements RpcClient {
    private static final int CONNECT_TIMEOUT_MILLIS = 3000;
    private static final int GRPC_MAX_MESSAGE_SIZE = Integer.MAX_VALUE;
    private final ManagedChannel channel;
    private final MessagingServiceGrpc.MessagingServiceFutureStub futureStub;
    private final MessagingServiceGrpc.MessagingServiceStub stub;
    private long activityNanoTime;

    public RpcClientImpl(Endpoints endpoints) throws SSLException {
        SslContextBuilder builder = GrpcSslContexts.forClient();
        builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        SslContext sslContext = builder.build();
        NettyChannelBuilder channelBuilder = ((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)endpoints.getGrpcTarget()).withOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)3000).maxInboundMessageSize(Integer.MAX_VALUE).intercept(new ClientInterceptor[]{LoggingInterceptor.getInstance()})).sslContext(sslContext);
        channelBuilder.disableRetry();
        List<InetSocketAddress> socketAddresses = endpoints.toSocketAddresses();
        if (null != socketAddresses) {
            IpNameResolverFactory ipNameResolverFactory = new IpNameResolverFactory(socketAddresses);
            channelBuilder.nameResolverFactory((NameResolver.Factory)ipNameResolverFactory);
        }
        this.channel = channelBuilder.build();
        this.futureStub = MessagingServiceGrpc.newFutureStub((Channel)this.channel);
        this.stub = MessagingServiceGrpc.newStub((Channel)this.channel);
        this.activityNanoTime = System.nanoTime();
    }

    @Override
    public Duration idleDuration() {
        return Duration.ofNanos(System.nanoTime() - this.activityNanoTime);
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public ListenableFuture<QueryRouteResponse> queryRoute(Metadata metadata, QueryRouteRequest request, Executor executor, Duration duration) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withExecutor(executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS)).queryRoute(request);
    }

    @Override
    public ListenableFuture<HeartbeatResponse> heartbeat(Metadata metadata, HeartbeatRequest request, Executor executor, Duration duration) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withExecutor(executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS)).heartbeat(request);
    }

    @Override
    public ListenableFuture<SendMessageResponse> sendMessage(Metadata metadata, SendMessageRequest request, Executor executor, Duration duration) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withExecutor(executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS)).sendMessage(request);
    }

    @Override
    public ListenableFuture<QueryAssignmentResponse> queryAssignment(Metadata metadata, QueryAssignmentRequest request, Executor executor, Duration duration) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withExecutor(executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS)).queryAssignment(request);
    }

    @Override
    public ListenableFuture<List<ReceiveMessageResponse>> receiveMessage(Metadata metadata, ReceiveMessageRequest request, ExecutorService executor, Duration duration) {
        this.activityNanoTime = System.nanoTime();
        final SettableFuture future = SettableFuture.create();
        final ArrayList responses = new ArrayList();
        ((MessagingServiceGrpc.MessagingServiceStub)((MessagingServiceGrpc.MessagingServiceStub)((MessagingServiceGrpc.MessagingServiceStub)this.stub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withExecutor((Executor)executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS)).receiveMessage(request, (StreamObserver)new StreamObserver<ReceiveMessageResponse>(){

            public void onNext(ReceiveMessageResponse response) {
                responses.add(response);
            }

            public void onError(Throwable t) {
                future.setException(t);
            }

            public void onCompleted() {
                future.set((Object)responses);
            }
        });
        return future;
    }

    @Override
    public ListenableFuture<AckMessageResponse> ackMessage(Metadata metadata, AckMessageRequest request, Executor executor, Duration duration) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withExecutor(executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS)).ackMessage(request);
    }

    @Override
    public ListenableFuture<ChangeInvisibleDurationResponse> changeInvisibleDuration(Metadata metadata, ChangeInvisibleDurationRequest request, Executor executor, Duration duration) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withExecutor(executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS)).changeInvisibleDuration(request);
    }

    @Override
    public ListenableFuture<ForwardMessageToDeadLetterQueueResponse> forwardMessageToDeadLetterQueue(Metadata metadata, ForwardMessageToDeadLetterQueueRequest request, Executor executor, Duration duration) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withExecutor(executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS)).forwardMessageToDeadLetterQueue(request);
    }

    @Override
    public ListenableFuture<EndTransactionResponse> endTransaction(Metadata metadata, EndTransactionRequest request, Executor executor, Duration duration) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withExecutor(executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS)).endTransaction(request);
    }

    @Override
    public ListenableFuture<NotifyClientTerminationResponse> notifyClientTermination(Metadata metadata, NotifyClientTerminationRequest request, Executor executor, Duration duration) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withExecutor(executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS)).notifyClientTermination(request);
    }

    @Override
    public StreamObserver<TelemetryCommand> telemetry(Metadata metadata, Executor executor, Duration duration, StreamObserver<TelemetryCommand> responseObserver) {
        ClientInterceptor interceptor = MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata);
        MessagingServiceGrpc.MessagingServiceStub stub0 = (MessagingServiceGrpc.MessagingServiceStub)((MessagingServiceGrpc.MessagingServiceStub)((MessagingServiceGrpc.MessagingServiceStub)this.stub.withInterceptors(new ClientInterceptor[]{interceptor})).withExecutor(executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS);
        return stub0.telemetry(responseObserver);
    }
}

