/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.prometheus;

import com.google.common.eventbus.EventBus;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Tag;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.HTTPServer;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.foundation.metrics.MetricsInitializer;
import org.apache.servicecomb.foundation.metrics.registry.GlobalRegistry;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusPublisher
extends Collector
implements Collector.Describable,
MetricsInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusPublisher.class);
    static final String METRICS_PROMETHEUS_ADDRESS = "servicecomb.metrics.prometheus.address";
    private HTTPServer httpServer;
    private GlobalRegistry globalRegistry;

    public void init(GlobalRegistry globalRegistry, EventBus eventBus, MetricsBootstrapConfig config) {
        this.globalRegistry = globalRegistry;
        String address = DynamicPropertyFactory.getInstance().getStringProperty(METRICS_PROMETHEUS_ADDRESS, "0.0.0.0:9696").get();
        try {
            InetSocketAddress socketAddress = this.getSocketAddress(address);
            this.register();
            this.httpServer = new HTTPServer(socketAddress, CollectorRegistry.defaultRegistry, true);
            LOGGER.info("Prometheus httpServer listened : {}.", (Object)address);
        }
        catch (Exception e) {
            throw new ServiceCombException("create http publish server failed,may bad address : " + address, (Throwable)e);
        }
    }

    private InetSocketAddress getSocketAddress(String address) {
        String[] hostAndPort = address.split(":");
        if (hostAndPort.length == 2) {
            return new InetSocketAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
        }
        throw new ServiceCombException("create http publish server failed,bad address : " + address);
    }

    public List<Collector.MetricFamilySamples> describe() {
        ArrayList<Collector.MetricFamilySamples> familySamples = new ArrayList<Collector.MetricFamilySamples>();
        if (this.globalRegistry == null) {
            return familySamples;
        }
        ArrayList samples = new ArrayList();
        for (Registry registry : this.globalRegistry.getRegistries()) {
            for (Meter meter : registry) {
                meter.measure().forEach(measurement -> {
                    Collector.MetricFamilySamples.Sample sample = this.convertMeasurementToSample((Measurement)measurement);
                    samples.add(sample);
                });
            }
        }
        familySamples.add(new Collector.MetricFamilySamples("ServiceComb_Metrics", Collector.Type.UNTYPED, "ServiceComb Metrics", samples));
        return familySamples;
    }

    protected Collector.MetricFamilySamples.Sample convertMeasurementToSample(Measurement measurement) {
        String prometheusName = measurement.id().name().replace(".", "_");
        ArrayList<String> labelNames = new ArrayList<String>();
        ArrayList<String> labelValues = new ArrayList<String>();
        labelNames.add("appId");
        labelValues.add(RegistryUtils.getAppId());
        for (Tag tag : measurement.id().tags()) {
            labelNames.add(tag.key());
            labelValues.add(tag.value());
        }
        return new Collector.MetricFamilySamples.Sample(prometheusName, labelNames, labelValues, measurement.value());
    }

    public List<Collector.MetricFamilySamples> collect() {
        return this.describe();
    }

    public void destroy() {
        if (this.httpServer == null) {
            return;
        }
        this.httpServer.stop();
        this.httpServer = null;
        LOGGER.info("Prometheus httpServer stopped.");
    }
}

