/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.log;

import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.servicecomb.foundation.common.log.NoCacheLog4jMarkerFactory;
import org.apache.servicecomb.foundation.common.utils.ReflectUtils;
import org.slf4j.IMarkerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticMarkerBinder;

public final class LogMarkerLeakFixUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMarkerLeakFixUtils.class);

    private LogMarkerLeakFixUtils() {
    }

    public static void fix() {
        Class<?> staticMarkerBinderClass = ReflectUtils.getClassByName(null, "org.slf4j.impl.StaticMarkerBinder");
        if (staticMarkerBinderClass == null) {
            return;
        }
        IMarkerFactory markerFactory = StaticMarkerBinder.SINGLETON.getMarkerFactory();
        if (markerFactory.getClass().getName().equals("org.apache.servicecomb.foundation.common.log.NoCacheLog4jMarkerFactory")) {
            return;
        }
        if (markerFactory.getClass().getName().equals("org.apache.logging.slf4j.Log4jMarkerFactory")) {
            LogMarkerLeakFixUtils.fixMarkerFactory(markerFactory, new NoCacheLog4jMarkerFactory(), "Failed to fix Log4jMarkerFactory leak problem.");
            LOGGER.info("fixed Log4jMarkerFactory marker leak problem.");
            return;
        }
    }

    private static void fixMarkerFactory(IMarkerFactory orgFactory, NoCacheLog4jMarkerFactory fixedFactory, String failMessage) {
        try {
            Field markerField = FieldUtils.getDeclaredField(orgFactory.getClass(), (String)"markerMap", (boolean)true);
            ConcurrentMap orgMarkerMap = (ConcurrentMap)FieldUtils.readField((Field)markerField, (Object)orgFactory);
            ConcurrentMap newMarkerMap = (ConcurrentMap)FieldUtils.readField((Field)markerField, (Object)((Object)fixedFactory));
            newMarkerMap.putAll(orgMarkerMap);
            ReflectUtils.setField(StaticMarkerBinder.SINGLETON, "markerFactory", (Object)fixedFactory);
        }
        catch (Throwable e) {
            throw new IllegalStateException(failMessage, e);
        }
    }
}

