/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric.consumer;

import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.metric.HystrixCommandCompletion;
import com.netflix.hystrix.metric.HystrixCommandCompletionStream;
import com.netflix.hystrix.metric.consumer.BucketedRollingCounterStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import rx.functions.Func2;

public class RollingCommandEventCounterStream
extends BucketedRollingCounterStream<HystrixCommandCompletion, long[], long[]> {
    private static final ConcurrentMap<String, RollingCommandEventCounterStream> streams = new ConcurrentHashMap<String, RollingCommandEventCounterStream>();
    private static final int NUM_EVENT_TYPES = HystrixEventType.values().length;

    public static RollingCommandEventCounterStream getInstance(HystrixCommandKey commandKey, HystrixCommandProperties properties) {
        int counterMetricWindow = properties.metricsRollingStatisticalWindowInMilliseconds().get();
        int numCounterBuckets = properties.metricsRollingStatisticalWindowBuckets().get();
        int counterBucketSizeInMs = counterMetricWindow / numCounterBuckets;
        return RollingCommandEventCounterStream.getInstance(commandKey, numCounterBuckets, counterBucketSizeInMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RollingCommandEventCounterStream getInstance(HystrixCommandKey commandKey, int numBuckets, int bucketSizeInMs) {
        RollingCommandEventCounterStream initialStream = (RollingCommandEventCounterStream)streams.get(commandKey.name());
        if (initialStream != null) {
            return initialStream;
        }
        Class<RollingCommandEventCounterStream> clazz = RollingCommandEventCounterStream.class;
        synchronized (RollingCommandEventCounterStream.class) {
            RollingCommandEventCounterStream existingStream = (RollingCommandEventCounterStream)streams.get(commandKey.name());
            if (existingStream == null) {
                RollingCommandEventCounterStream newStream = new RollingCommandEventCounterStream(commandKey, numBuckets, bucketSizeInMs, HystrixCommandMetrics.appendEventToBucket, HystrixCommandMetrics.bucketAggregator);
                streams.putIfAbsent(commandKey.name(), newStream);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return newStream;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return existingStream;
        }
    }

    public static void reset() {
        streams.clear();
    }

    private RollingCommandEventCounterStream(HystrixCommandKey commandKey, int numCounterBuckets, int counterBucketSizeInMs, Func2<long[], HystrixCommandCompletion, long[]> reduceCommandCompletion, Func2<long[], long[], long[]> reduceBucket) {
        super(HystrixCommandCompletionStream.getInstance(commandKey), numCounterBuckets, counterBucketSizeInMs, reduceCommandCompletion, reduceBucket);
    }

    @Override
    long[] getEmptyBucketSummary() {
        return new long[NUM_EVENT_TYPES];
    }

    @Override
    long[] getEmptyOutputValue() {
        return new long[NUM_EVENT_TYPES];
    }

    public long getLatest(HystrixEventType eventType) {
        return ((long[])this.getLatest())[eventType.ordinal()];
    }
}

