/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.validation.constraints.NotNull;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.server.ServerWebExchange;

public class BetweenRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    public static final String DATETIME1_KEY = "datetime1";
    public static final String DATETIME2_KEY = "datetime2";

    public BetweenRoutePredicateFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(DATETIME1_KEY, DATETIME2_KEY);
    }

    @Override
    public Predicate<ServerWebExchange> apply(Config config) {
        ZonedDateTime datetime1 = config.datetime1;
        ZonedDateTime datetime2 = config.datetime2;
        Assert.isTrue((boolean)datetime1.isBefore(datetime2), (String)(config.datetime1 + " must be before " + config.datetime2));
        return exchange -> {
            ZonedDateTime now = ZonedDateTime.now();
            return now.isAfter(datetime1) && now.isBefore(datetime2);
        };
    }

    @Validated
    public static class Config {
        @NotNull
        private ZonedDateTime datetime1;
        @NotNull
        private ZonedDateTime datetime2;

        public ZonedDateTime getDatetime1() {
            return this.datetime1;
        }

        public Config setDatetime1(ZonedDateTime datetime1) {
            this.datetime1 = datetime1;
            return this;
        }

        public ZonedDateTime getDatetime2() {
            return this.datetime2;
        }

        public Config setDatetime2(ZonedDateTime datetime2) {
            this.datetime2 = datetime2;
            return this;
        }
    }
}

