/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.converter.model;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.Property;
import java.util.Map;
import javassist.CtClass;
import org.apache.servicecomb.common.javassist.ClassConfig;
import org.apache.servicecomb.common.javassist.CtType;
import org.apache.servicecomb.common.javassist.CtTypeJavaType;
import org.apache.servicecomb.common.javassist.JavassistUtils;
import org.apache.servicecomb.swagger.converter.ConverterMgr;
import org.apache.servicecomb.swagger.converter.SwaggerToClassGenerator;
import org.apache.servicecomb.swagger.converter.model.AbstractModelConverter;
import org.apache.servicecomb.swagger.converter.property.MapPropertyConverter;
import org.apache.servicecomb.swagger.generator.core.utils.ClassUtils;

public class ModelImplConverter
extends AbstractModelConverter {
    @Override
    public JavaType doConvert(SwaggerToClassGenerator swaggerToClassGenerator, Object model) {
        ModelImpl modelImpl = (ModelImpl)model;
        JavaType javaType = ConverterMgr.findJavaType(modelImpl.getType(), modelImpl.getFormat());
        if (javaType != null) {
            return javaType;
        }
        if (modelImpl.getReference() != null) {
            return swaggerToClassGenerator.convertRef(modelImpl.getReference());
        }
        if (modelImpl.getAdditionalProperties() != null) {
            return MapPropertyConverter.findJavaType(swaggerToClassGenerator, modelImpl.getAdditionalProperties());
        }
        if ("object".equals(modelImpl.getType()) && modelImpl.getProperties() == null && modelImpl.getName() == null) {
            return TypeFactory.defaultInstance().constructType(Object.class);
        }
        return this.getOrCreateType(swaggerToClassGenerator, modelImpl);
    }

    protected JavaType getOrCreateType(SwaggerToClassGenerator swaggerToClassGenerator, ModelImpl modelImpl) {
        String clsName = ClassUtils.getClassName(this.findVendorExtensions(modelImpl));
        clsName = ClassUtils.correctClassName(clsName);
        return this.getOrCreateType(swaggerToClassGenerator, modelImpl.getProperties(), clsName);
    }

    protected JavaType getOrCreateType(SwaggerToClassGenerator swaggerToClassGenerator, Map<String, Property> properties, String clsName) {
        Class<?> cls = ClassUtils.getClassByName(swaggerToClassGenerator.getClassLoader(), clsName);
        if (cls != null) {
            return swaggerToClassGenerator.getTypeFactory().constructType(cls);
        }
        CtClass ctClass = this.getOrCreateCtClass(swaggerToClassGenerator, properties, clsName);
        return new CtTypeJavaType(new CtType(ctClass));
    }

    private CtClass getOrCreateCtClass(SwaggerToClassGenerator swaggerToClassGenerator, Map<String, Property> properties, String clsName) {
        CtClass ctClass = swaggerToClassGenerator.getClassPool().getOrNull(clsName);
        if (ctClass != null) {
            return ctClass;
        }
        swaggerToClassGenerator.getClassPool().makeClass(clsName);
        ClassConfig classConfig = new ClassConfig();
        classConfig.setClassName(clsName);
        if (null != properties) {
            for (Map.Entry<String, Property> entry : properties.entrySet()) {
                JavaType propertyJavaType = swaggerToClassGenerator.convert(entry.getValue());
                classConfig.addField(entry.getKey(), propertyJavaType);
            }
        }
        return JavassistUtils.createCtClass((ClassLoader)swaggerToClassGenerator.getClassLoader(), (ClassConfig)classConfig);
    }
}

