/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.web;

import com.netflix.zuul.context.RequestContext;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.web.ErrorController;
import org.springframework.cloud.netflix.zuul.filters.RefreshableRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.cloud.netflix.zuul.web.ZuulController;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

public class ZuulHandlerMapping
extends AbstractUrlHandlerMapping {
    private final RouteLocator routeLocator;
    private final ZuulController zuul;
    private ErrorController errorController;
    private PathMatcher pathMatcher = new AntPathMatcher();
    private volatile boolean dirty = true;

    public ZuulHandlerMapping(RouteLocator routeLocator, ZuulController zuul) {
        this.routeLocator = routeLocator;
        this.zuul = zuul;
        this.setOrder(-200);
    }

    protected HandlerExecutionChain getCorsHandlerExecutionChain(HttpServletRequest request, HandlerExecutionChain chain, CorsConfiguration config) {
        if (config == null) {
            return chain;
        }
        return super.getCorsHandlerExecutionChain(request, chain, config);
    }

    public void setErrorController(ErrorController errorController) {
        this.errorController = errorController;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        if (this.routeLocator instanceof RefreshableRouteLocator) {
            ((RefreshableRouteLocator)this.routeLocator).refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object lookupHandler(String urlPath, HttpServletRequest request) throws Exception {
        if (this.errorController != null && urlPath.equals(this.errorController.getErrorPath())) {
            return null;
        }
        if (this.isIgnoredPath(urlPath, this.routeLocator.getIgnoredPaths())) {
            return null;
        }
        RequestContext ctx = RequestContext.getCurrentContext();
        if (ctx.containsKey((Object)"forward.to")) {
            return null;
        }
        if (this.dirty) {
            ZuulHandlerMapping zuulHandlerMapping = this;
            synchronized (zuulHandlerMapping) {
                if (this.dirty) {
                    this.registerHandlers();
                    this.dirty = false;
                }
            }
        }
        return super.lookupHandler(urlPath, request);
    }

    private boolean isIgnoredPath(String urlPath, Collection<String> ignored) {
        if (ignored != null) {
            for (String ignoredPath : ignored) {
                if (!this.pathMatcher.match(ignoredPath, urlPath)) continue;
                return true;
            }
        }
        return false;
    }

    private void registerHandlers() {
        List<Route> routes = this.routeLocator.getRoutes();
        if (routes.isEmpty()) {
            this.logger.warn((Object)"No routes found from RouteLocator");
        } else {
            for (Route route : routes) {
                this.registerHandler(route.getFullPath(), (Object)this.zuul);
            }
        }
    }
}

