/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cloud.nio.multipart.io.buffer;

import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cloud.nio.multipart.io.buffer.CircularBuffer;

public class EndOfLineBuffer {
    private static final Logger log = LoggerFactory.getLogger(EndOfLineBuffer.class);
    final CircularBuffer circularBuffer;
    volatile OutputStream flushOutputStream;
    volatile byte[] endOfLineSequence;
    volatile int endOfLineSequenceMatchingLength;

    public EndOfLineBuffer(int size, byte[] endOfLineSequence, OutputStream flushOutputStream) {
        if (endOfLineSequence.length >= size) {
            throw new IllegalArgumentException("The end of line sequence cannot be larger than the buffer size. End of line sequence length: " + endOfLineSequence.length + ", buffer size: " + size);
        }
        this.circularBuffer = new CircularBuffer(size);
        this.flushOutputStream = flushOutputStream;
        this.endOfLineSequence = endOfLineSequence;
        this.endOfLineSequenceMatchingLength = 0;
    }

    public void recycle(byte[] endOfLineSequence, OutputStream flushOutputStream) {
        this.circularBuffer.reset();
        this.flushOutputStream = flushOutputStream;
        this.endOfLineSequence = endOfLineSequence;
        this.endOfLineSequenceMatchingLength = 0;
    }

    public boolean write(byte data) {
        if (this.isEndOfLine()) {
            throw new IllegalStateException("Buffer is in an end of line state. You need to recycle it before writing.");
        }
        this.flushIfNeeded();
        this.circularBuffer.write(data);
        boolean isEndOfLine = this.updateEndOfLineMatchingStatus(data);
        if (isEndOfLine) {
            this.flushIfNeeded();
        }
        return isEndOfLine;
    }

    public boolean isEndOfLine() {
        return this.endOfLineSequenceMatchingLength == this.endOfLineSequence.length;
    }

    boolean updateEndOfLineMatchingStatus(byte b) {
        this.endOfLineSequenceMatchingLength = this.endOfLineSequence[this.endOfLineSequenceMatchingLength] == b ? ++this.endOfLineSequenceMatchingLength : (this.endOfLineSequence[0] == b ? 1 : 0);
        return this.isEndOfLine();
    }

    void flushIfNeeded() {
        if (this.flushOutputStream == null) {
            return;
        }
        if (this.circularBuffer.isFull() || this.isEndOfLine()) {
            try {
                if (this.circularBuffer.getAvailableDataLength() > 0) {
                    if (this.endOfLineSequenceMatchingLength > 0) {
                        int chunkSize = this.circularBuffer.availableReadLength - this.endOfLineSequenceMatchingLength;
                        this.circularBuffer.readChunk(this.flushOutputStream, chunkSize);
                    } else {
                        this.circularBuffer.readAll(this.flushOutputStream);
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Error flushing the buffer data.", e);
            }
        }
        if (this.circularBuffer.isFull()) {
            throw new IllegalStateException("Unexpected error. Buffer is full after a flush.");
        }
    }
}

