/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.parser;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.protostuff.compiler.ParserModule;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.parser.FileDescriptorLoader;
import io.protostuff.compiler.parser.FileReader;
import io.protostuff.compiler.parser.FileReaderFactory;
import io.protostuff.compiler.parser.ProtoContext;
import java.util.Collections;
import org.apache.servicecomb.foundation.protobuf.internal.parser.ContentFileReader;

public class ProtoParser {
    private Injector injector = Guice.createInjector((Module[])new Module[]{new ParserModule()});
    private FileReaderFactory fileReaderFactory = (FileReaderFactory)this.injector.getInstance(FileReaderFactory.class);
    private FileReader defaultReader = this.fileReaderFactory.create(Collections.emptyList());
    private FileDescriptorLoader loader = (FileDescriptorLoader)this.injector.getInstance(FileDescriptorLoader.class);

    public Proto parseFromContent(String content) {
        ProtoContext context = this.loader.load((FileReader)new ContentFileReader(this.defaultReader), content);
        return context.getProto();
    }

    public Proto parse(String name) {
        ProtoContext context = this.loader.load(this.defaultReader, name);
        return context.getProto();
    }
}

