/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.OutputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import java.util.Collection;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.AbstractWriters;

public class RepeatedWriteSchemas {
    public static <T, ELE_TYPE> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor, AbstractWriters<ELE_TYPE> writers) {
        JavaType javaType = propertyDescriptor.getJavaType();
        if (writers.arrayClass.isAssignableFrom(javaType.getRawClass())) {
            return new ArraySchema(protoField, propertyDescriptor, writers);
        }
        if (Collection.class.isAssignableFrom(javaType.getRawClass())) {
            return new CollectionSchema(protoField, propertyDescriptor, writers);
        }
        return new DynamicSchema(protoField, propertyDescriptor, writers);
    }

    private static class CollectionSchema<T, ELE_TYPE>
    extends DynamicSchema<T, ELE_TYPE> {
        private final Getter<T, Collection<ELE_TYPE>> getter;

        public CollectionSchema(Field protoField, PropertyDescriptor propertyDescriptor, AbstractWriters<ELE_TYPE> writers) {
            super(protoField, propertyDescriptor, writers);
            this.getter = (Getter)propertyDescriptor.getGetter();
        }

        @Override
        public final void getAndWriteTo(OutputEx output, T message) throws IOException {
            Collection value = (Collection)this.getter.get(message);
            if (value == null) {
                return;
            }
            this.writers.collectionWriter.writeTo(output, value);
        }
    }

    private static class ArraySchema<T, ELE_TYPE>
    extends DynamicSchema<T, ELE_TYPE> {
        private final Getter<T, ELE_TYPE[]> getter;

        public ArraySchema(Field protoField, PropertyDescriptor propertyDescriptor, AbstractWriters<ELE_TYPE> writers) {
            super(protoField, propertyDescriptor, writers);
            this.getter = (Getter)propertyDescriptor.getGetter();
        }

        @Override
        public final void getAndWriteTo(OutputEx output, T message) throws IOException {
            Object[] value = (Object[])this.getter.get(message);
            if (value == null) {
                return;
            }
            this.writers.arrayWriter.writeTo(output, value);
        }
    }

    static class DynamicSchema<T, ELE_TYPE>
    extends FieldSchema<T> {
        protected final AbstractWriters<ELE_TYPE> writers;

        public DynamicSchema(Field protoField, PropertyDescriptor propertyDescriptor, AbstractWriters<ELE_TYPE> writers) {
            super(protoField, propertyDescriptor.getJavaType());
            this.writers = writers;
        }

        @Override
        public final void writeTo(OutputEx output, Object value) throws IOException {
            this.writers.dynamicWriteTo(output, value);
        }
    }
}

