/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.vertx;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.Map;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.metrics.meter.PeriodMeter;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultEndpointMetric;
import org.apache.servicecomb.metrics.core.meter.vertx.EndpointMeter;

public class VertxEndpointsMeter
implements PeriodMeter {
    private final Map<String, DefaultEndpointMetric> endpointMetricMap;
    protected final MeterRegistry meterRegistry;
    protected final String name;
    protected final Tags tags;
    private final Map<String, EndpointMeter> endpointMeterMap = new ConcurrentHashMapEx();

    public <T extends DefaultEndpointMetric> VertxEndpointsMeter(MeterRegistry meterRegistry, String name, Tags tags, Map<String, T> endpointMetricMap) {
        this.meterRegistry = meterRegistry;
        this.name = name;
        this.tags = tags;
        this.endpointMetricMap = endpointMetricMap;
    }

    private void syncMeters(long msNow, long secondInterval) {
        for (EndpointMeter meter : this.endpointMeterMap.values()) {
            if (this.endpointMetricMap.containsKey(meter.getMetric().getAddress())) continue;
            EndpointMeter removed = this.endpointMeterMap.remove(meter.getMetric().getAddress());
            removed.destroy();
        }
        for (DefaultEndpointMetric metric : this.endpointMetricMap.values()) {
            EndpointMeter updated = this.endpointMeterMap.computeIfAbsent(metric.getAddress(), address -> this.createEndpointMeter(metric));
            updated.poll(msNow, secondInterval);
        }
    }

    protected EndpointMeter createEndpointMeter(DefaultEndpointMetric metric) {
        return new EndpointMeter(this.meterRegistry, this.name, this.tags, metric);
    }

    public void poll(long msNow, long secondInterval) {
        this.syncMeters(msNow, secondInterval);
    }
}

