/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.esri;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.Capability;
import org.apache.sis.storage.base.PRJDataStore;
import org.apache.sis.storage.base.StoreMetadata;
import org.apache.sis.storage.esri.RawRasterStore;

@StoreMetadata(formatName="BIL/BIP/BSQ", fileSuffixes={"bil", "bip", "bsq"}, capabilities={Capability.READ}, resourceTypes={GridCoverageResource.class})
public final class RawRasterStoreProvider
extends PRJDataStore.Provider {
    static final String NAME = "BIL/BIP/BSQ";
    static final String HDR = "hdr";
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.storage.esri");

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public ProbeResult probeContent(StorageConnector connector) throws DataStoreException {
        Path path = connector.getStorageAs(Path.class);
        if (path != null) {
            Object filename = path.getFileName().toString();
            int s = ((String)filename).lastIndexOf(46);
            filename = (String)(s >= 0 ? ((String)filename).substring(0, s + 1) : (String)filename + ".") + HDR;
            if (Files.isRegularFile(path = path.resolveSibling((String)filename), new LinkOption[0])) {
                return ProbeResult.SUPPORTED;
            }
        } else if (connector.getStorageAs(URL.class) != null) {
            return ProbeResult.UNDETERMINED;
        }
        return ProbeResult.UNSUPPORTED_STORAGE;
    }

    @Override
    public DataStore open(StorageConnector connector) throws DataStoreException {
        return new RawRasterStore(this, connector);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }
}

