/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper.jts;

import java.lang.reflect.Array;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.apache.sis.geometry.wrapper.jts.Factory;
import org.apache.sis.util.resources.Errors;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

class ConverterTo2D {
    protected static final int DIMENSION = 2;
    protected final GeometryFactory factory;

    protected ConverterTo2D(GeometryFactory factory, boolean isFloat) {
        this.factory = factory != null ? factory : Factory.INSTANCE.factory(isFloat);
    }

    protected final Geometry anyTo2D(Geometry geometry) {
        if (geometry instanceof Point) {
            return this.enforce2D((Point)geometry);
        }
        if (geometry instanceof LineString) {
            return this.enforce2D((LineString)geometry);
        }
        if (geometry instanceof LinearRing) {
            return this.enforce2D((LinearRing)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.enforce2D((Polygon)geometry);
        }
        if (geometry instanceof MultiPoint) {
            return this.enforce2D((MultiPoint)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.enforce2D((MultiLineString)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return this.enforce2D((MultiPolygon)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.collect2D((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException(Errors.format((short)200, (Object)geometry.getGeometryType()));
    }

    protected final GeometryCollection collect2D(GeometryCollection geometry) {
        return this.enforce2D(geometry, Geometry.class, this::anyTo2D, GeometryFactory::createGeometryCollection);
    }

    protected final MultiPoint enforce2D(MultiPoint geometry) {
        return this.enforce2D(geometry, Point.class, this::enforce2D, GeometryFactory::createMultiPoint);
    }

    protected final Point enforce2D(Point geometry) {
        return this.enforce2D(geometry, geometry.getCoordinateSequence(), GeometryFactory::createPoint);
    }

    protected final MultiLineString enforce2D(MultiLineString geometry) {
        return this.enforce2D(geometry, LineString.class, this::enforce2D, GeometryFactory::createMultiLineString);
    }

    protected final LineString enforce2D(LineString geometry) {
        return this.enforce2D(geometry, geometry.getCoordinateSequence(), GeometryFactory::createLineString);
    }

    protected final LinearRing enforce2D(LinearRing geometry) {
        return this.enforce2D(geometry, geometry.getCoordinateSequence(), GeometryFactory::createLinearRing);
    }

    protected final MultiPolygon enforce2D(MultiPolygon geometry) {
        return this.enforce2D(geometry, Polygon.class, this::enforce2D, GeometryFactory::createMultiPolygon);
    }

    protected final Polygon enforce2D(Polygon geometry) {
        LinearRing exterior = geometry.getExteriorRing();
        boolean changed = exterior != (exterior = this.enforce2D(exterior));
        LinearRing[] rings = new LinearRing[geometry.getNumInteriorRing()];
        for (int i = 0; i < rings.length; ++i) {
            LinearRing interior = geometry.getInteriorRingN(i);
            rings[i] = this.enforce2D(interior);
            changed |= rings[i] != interior;
        }
        return changed ? this.factory.createPolygon(exterior, rings) : geometry;
    }

    private <G extends GeometryCollection, E extends Geometry> G enforce2D(G collection, Class<E> componentType, UnaryOperator<E> toComponent2D, BiFunction<GeometryFactory, E[], G> creator) {
        boolean changed = false;
        Geometry[] components = (Geometry[])Array.newInstance(componentType, collection.getNumGeometries());
        for (int i = 0; i < components.length; ++i) {
            Geometry component = (Geometry)componentType.cast(collection.getGeometryN(i));
            components[i] = (Geometry)toComponent2D.apply(component);
            changed |= components[i] != component;
        }
        return (G)(changed ? (GeometryCollection)creator.apply(this.factory, components) : collection);
    }

    private <G extends Geometry> G enforce2D(G geometry, CoordinateSequence cs, BiFunction<GeometryFactory, CoordinateSequence, G> creator) {
        if (cs.getDimension() == 2) {
            return geometry;
        }
        int size = cs.size();
        CoordinateSequence copy = this.factory.getCoordinateSequenceFactory().create(size, 2);
        for (int i = 0; i < size; ++i) {
            copy.setOrdinate(i, 0, cs.getX(i));
            copy.setOrdinate(i, 1, cs.getY(i));
        }
        return (G)((Geometry)creator.apply(this.factory, copy));
    }
}

