/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.util.Iterator;
import org.apache.sis.util.internal.shared.AbstractIterator;

final class LazySynchronizedIterator<E>
extends AbstractIterator<E> {
    private final Iterator<Iterable<? extends E>> providers;
    private Iterable<? extends E> provider;
    private Iterator<? extends E> it;

    public LazySynchronizedIterator(Iterator<Iterable<? extends E>> providers) {
        this.providers = providers;
        if (providers.hasNext()) {
            this.provider = providers.next();
            this.it = this.provider.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        while (this.it != null) {
            Iterable<? extends E> iterable = this.provider;
            synchronized (iterable) {
                while (this.it.hasNext()) {
                    this.next = this.it.next();
                    if (this.next == null) continue;
                    return true;
                }
                this.it = null;
            }
            if (!this.providers.hasNext()) continue;
            this.provider = this.providers.next();
            this.it = this.provider.iterator();
        }
        return false;
    }
}

