/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.bookkeeper;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.apache.sling.commons.metrics.Counter;
import org.apache.sling.commons.metrics.Histogram;
import org.apache.sling.commons.metrics.Meter;
import org.apache.sling.commons.metrics.MetricsService;
import org.apache.sling.commons.metrics.Timer;
import org.apache.sling.distribution.journal.messages.PackageStatusMessage;
import org.apache.sling.distribution.journal.metrics.Tag;
import org.apache.sling.distribution.journal.metrics.TaggedMetrics;

public class SubscriberMetrics {
    private static final String TAG_SUB_NAME = "sub_name";
    private static final String TAG_PUB_NAME = "pub_name";
    private static final String TAG_STATUS = "status";
    private static final String TAG_EDITABLE = "editable";
    public static final String SUB_COMPONENT = "distribution.journal.subscriber.";
    private static final String PACKAGE_STATUS_COUNT = "distribution.journal.subscriber.package_status_count";
    private static final String CURRENT_RETRIES = "distribution.journal.subscriber.current_retries";
    private static final String IMPORTED_PACKAGE_SIZE = "distribution.journal.subscriber.imported_package_size";
    private static final String ITEMS_BUFFER_SIZE = "distribution.journal.subscriber.items_buffer_size";
    private static final String FAILED_PACKAGE_IMPORTS = "distribution.journal.subscriber.failed_package_imports";
    private static final String TRANSIENT_IMPORT_ERRORS = "distribution.journal.subscriber.transient_import_errors";
    private static final String PERMANENT_IMPORT_ERRORS = "distribution.journal.subscriber.permanent_import_errors";
    private static final String IMPORT_PRE_PROCESS_REQUEST_COUNT = "distribution.journal.subscriber.import_pre_process_request_count";
    private static final String IMPORT_POST_PROCESS_SUCCESS_COUNT = "distribution.journal.subscriber.import_post_process_success_count";
    private static final String IMPORT_POST_PROCESS_REQUEST_COUNT = "distribution.journal.subscriber.import_post_process_request_count";
    private static final String INVALIDATION_PROCESS_SUCCESS_COUNT = "distribution.journal.subscriber.invalidation_process_success_count";
    private static final String INVALIDATION_PROCESS_REQUEST_COUNT = "distribution.journal.subscriber.invalidation_process_request_count";
    private static final String IMPORT_PRE_PROCESS_SUCCESS_COUNT = "distribution.journal.subscriber.import_pre_process_success_count";
    private static final String IMPORTED_PACKAGE_DURATION = "distribution.journal.subscriber.imported_package_duration";
    private static final String REMOVED_PACKAGE_DURATION = "distribution.journal.subscriber.removed_package_duration";
    private static final String REMOVED_FAILED_PACKAGE_DURATION = "distribution.journal.subscriber.removed_failed_package_duration";
    private static final String SEND_STORED_STATUS_DURATION = "distribution.journal.subscriber.send_stored_status_duration";
    private static final String PROCESS_QUEUE_ITEM_DURATION = "distribution.journal.subscriber.process_queue_item_duration";
    private static final String REQUEST_DISTRIBUTED_DURATION = "distribution.journal.subscriber.request_distributed_duration";
    private static final String PACKAGE_JOURNAL_DISTRIBUTION_DURATION = "distribution.journal.subscriber.package_journal_distribution_duration";
    private static final String IMPORT_PRE_PROCESS_DURATION = "distribution.journal.subscriber.import_pre_process_duration";
    private static final String IMPORT_POST_PROCESS_DURATION = "distribution.journal.subscriber.import_post_process_duration";
    private static final String INVALIDATION_PROCESS_DURATION = "distribution.journal.subscriber.invalidation_process_duration";
    private final MetricsService metricsService;
    private final Tag tagSubName;
    private final Tag tagPubName;
    private final Tag tagEditable;
    private final List<Tag> tags;

    public SubscriberMetrics(MetricsService metricsService, String subAgentName, String pubAgentName, boolean editable) {
        this.metricsService = metricsService;
        this.tagSubName = Tag.of(TAG_SUB_NAME, subAgentName);
        this.tagEditable = Tag.of(TAG_EDITABLE, Boolean.toString(editable));
        this.tagPubName = Tag.of(TAG_PUB_NAME, pubAgentName);
        this.tags = Arrays.asList(this.tagSubName, this.tagPubName, this.tagEditable);
    }

    public Histogram getImportedPackageSize() {
        return this.metricsService.histogram(TaggedMetrics.getMetricName(IMPORTED_PACKAGE_SIZE, this.tags));
    }

    public Counter getItemsBufferSize() {
        return this.metricsService.counter(TaggedMetrics.getMetricName(ITEMS_BUFFER_SIZE, this.tags));
    }

    public Timer getImportedPackageDuration() {
        return this.metricsService.timer(TaggedMetrics.getMetricName(IMPORTED_PACKAGE_DURATION, this.tags));
    }

    public Timer getRemovedPackageDuration() {
        return this.metricsService.timer(TaggedMetrics.getMetricName(REMOVED_PACKAGE_DURATION, this.tags));
    }

    public Timer getRemovedFailedPackageDuration() {
        return this.metricsService.timer(TaggedMetrics.getMetricName(REMOVED_FAILED_PACKAGE_DURATION, this.tags));
    }

    public Meter getFailedPackageImports() {
        return this.metricsService.meter(TaggedMetrics.getMetricName(FAILED_PACKAGE_IMPORTS, this.tags));
    }

    public Timer getSendStoredStatusDuration() {
        return this.metricsService.timer(TaggedMetrics.getMetricName(SEND_STORED_STATUS_DURATION, this.tags));
    }

    public Timer getProcessQueueItemDuration() {
        return this.metricsService.timer(TaggedMetrics.getMetricName(PROCESS_QUEUE_ITEM_DURATION, this.tags));
    }

    public Timer getPackageDistributedDuration() {
        return this.metricsService.timer(TaggedMetrics.getMetricName(REQUEST_DISTRIBUTED_DURATION, this.tags));
    }

    public Timer getPackageJournalDistributionDuration() {
        return this.metricsService.timer(TaggedMetrics.getMetricName(PACKAGE_JOURNAL_DISTRIBUTION_DURATION, this.tags));
    }

    public Counter getPackageStatusCounter(PackageStatusMessage.Status status) {
        Tag tagStatus = Tag.of(TAG_STATUS, status.name());
        String name = TaggedMetrics.getMetricName(PACKAGE_STATUS_COUNT, Arrays.asList(this.tagSubName, this.tagEditable, tagStatus));
        return this.metricsService.counter(name);
    }

    public Timer getImportPreProcessDuration() {
        return this.metricsService.timer(TaggedMetrics.getMetricName(IMPORT_PRE_PROCESS_DURATION, this.tags));
    }

    public Counter getImportPreProcessSuccess() {
        return this.metricsService.counter(TaggedMetrics.getMetricName(IMPORT_PRE_PROCESS_SUCCESS_COUNT, this.tags));
    }

    public Counter getImportPreProcessRequest() {
        return this.metricsService.counter(TaggedMetrics.getMetricName(IMPORT_PRE_PROCESS_REQUEST_COUNT, this.tags));
    }

    public Timer getImportPostProcessDuration() {
        return this.metricsService.timer(TaggedMetrics.getMetricName(IMPORT_POST_PROCESS_DURATION, this.tags));
    }

    public Counter getImportPostProcessSuccess() {
        return this.metricsService.counter(TaggedMetrics.getMetricName(IMPORT_POST_PROCESS_SUCCESS_COUNT, this.tags));
    }

    public Counter getImportPostProcessRequest() {
        return this.metricsService.counter(TaggedMetrics.getMetricName(IMPORT_POST_PROCESS_REQUEST_COUNT, this.tags));
    }

    public Timer getInvalidationProcessDuration() {
        return this.metricsService.timer(TaggedMetrics.getMetricName(INVALIDATION_PROCESS_DURATION, this.tags));
    }

    public Counter getInvalidationProcessSuccess() {
        return this.metricsService.counter(TaggedMetrics.getMetricName(INVALIDATION_PROCESS_SUCCESS_COUNT, this.tags));
    }

    public Counter getInvalidationProcessRequest() {
        return this.metricsService.counter(TaggedMetrics.getMetricName(INVALIDATION_PROCESS_REQUEST_COUNT, this.tags));
    }

    public Counter getTransientImportErrors() {
        return this.metricsService.counter(TaggedMetrics.getMetricName(TRANSIENT_IMPORT_ERRORS, this.tags));
    }

    public Counter getPermanentImportErrors() {
        return this.metricsService.counter(TaggedMetrics.getMetricName(PERMANENT_IMPORT_ERRORS, this.tags));
    }

    public void currentRetries(Supplier<Integer> retriesCallback) {
        this.metricsService.gauge(TaggedMetrics.getMetricName(CURRENT_RETRIES, this.tags), retriesCallback);
    }
}

