/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.publisher;

import java.io.Closeable;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.apache.sling.distribution.journal.FullMessage;
import org.apache.sling.distribution.journal.HandlerAdapter;
import org.apache.sling.distribution.journal.MessageHandler;
import org.apache.sling.distribution.journal.MessageSender;
import org.apache.sling.distribution.journal.MessagingProvider;
import org.apache.sling.distribution.journal.Reset;
import org.apache.sling.distribution.journal.impl.discovery.DiscoveryService;
import org.apache.sling.distribution.journal.impl.discovery.State;
import org.apache.sling.distribution.journal.impl.discovery.TopologyView;
import org.apache.sling.distribution.journal.impl.publisher.PublishMetrics;
import org.apache.sling.distribution.journal.impl.publisher.QueueCacheSeeder;
import org.apache.sling.distribution.journal.impl.publisher.RangePoller;
import org.apache.sling.distribution.journal.messages.ClearCommand;
import org.apache.sling.distribution.journal.messages.PackageMessage;
import org.apache.sling.distribution.journal.queue.CacheCallback;
import org.apache.sling.distribution.journal.queue.ClearCallback;
import org.apache.sling.distribution.journal.queue.QueueState;
import org.apache.sling.distribution.journal.shared.AgentId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingCacheCallback
implements CacheCallback {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final MessagingProvider messagingProvider;
    private final String packageTopic;
    private final PublishMetrics publishMetrics;
    private final DiscoveryService discoveryService;
    private final Consumer<ClearCommand> commandSender;

    public MessagingCacheCallback(MessagingProvider messagingProvider, String packageTopic, PublishMetrics publishMetrics, DiscoveryService discoveryService, Consumer<ClearCommand> commandSender) {
        this.messagingProvider = messagingProvider;
        this.packageTopic = packageTopic;
        this.publishMetrics = publishMetrics;
        this.discoveryService = discoveryService;
        this.commandSender = commandSender;
    }

    @Override
    public Closeable createConsumer(MessageHandler<PackageMessage> handler) {
        this.log.info("Starting consumer");
        QueueCacheSeeder seeder = new QueueCacheSeeder((MessageSender<PackageMessage>)this.messagingProvider.createSender(this.packageTopic));
        Closeable poller = this.messagingProvider.createPoller(this.packageTopic, Reset.latest, new HandlerAdapter[]{HandlerAdapter.create(PackageMessage.class, (info, message) -> {
            seeder.close();
            handler.handle(info, message);
        })});
        seeder.startSeeding();
        return () -> IOUtils.closeQuietly((Closeable[])new Closeable[]{seeder, poller});
    }

    @Override
    public List<FullMessage<PackageMessage>> fetchRange(long minOffset, long maxOffset) throws InterruptedException {
        this.publishMetrics.getQueueCacheFetchCount().increment();
        return new RangePoller(this.messagingProvider, this.packageTopic, minOffset, maxOffset, 30).fetchRange();
    }

    @Override
    public QueueState getQueueState(String pubAgentName, String subAgentId) {
        TopologyView view = this.discoveryService.getTopologyView();
        State state = view.getState(subAgentId, pubAgentName);
        if (state == null) {
            return null;
        }
        ClearCallback editableCallback = offset -> this.sendClearCommand(pubAgentName, new AgentId(subAgentId), offset);
        ClearCallback clearCallback = state.isEditable() ? editableCallback : null;
        long curOffset = state.getOffset();
        int headRetries = state.getRetries();
        int maxRetries = state.getMaxRetries();
        return new QueueState(curOffset, headRetries, maxRetries, clearCallback);
    }

    private void sendClearCommand(String pubAgentName, AgentId subAgentId, long offset) {
        ClearCommand command = ClearCommand.builder().pubAgentName(pubAgentName).subSlingId(subAgentId.getSlingId()).subAgentName(subAgentId.getAgentName()).offset(offset).build();
        this.log.info("Sending clear command {}", (Object)command);
        this.commandSender.accept(command);
    }

    @Override
    public Set<String> getSubscribedAgentIds(String pubAgentName) {
        return this.discoveryService.getTopologyView().getSubscribedAgentIds(pubAgentName);
    }
}

