/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hapi.client.impl.microdata;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.http.NameValuePair;
import org.apache.sling.hapi.client.ClientException;
import org.apache.sling.hapi.client.Document;
import org.apache.sling.hapi.client.HtmlClient;
import org.apache.sling.hapi.client.Item;
import org.apache.sling.hapi.client.Items;
import org.apache.sling.hapi.client.forms.internal.FormValues;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class MicrodataDocument
implements Document {
    private org.jsoup.nodes.Document jsoupDocument;
    private HtmlClient client;

    public MicrodataDocument(String html, HtmlClient client, String baseUrl) {
        this.jsoupDocument = Jsoup.parse((String)html, (String)baseUrl);
        this.client = client;
    }

    @Override
    public Items link(String rel) throws ClientException {
        Item me = this.toItem((Element)this.jsoupDocument);
        return me.link(rel);
    }

    @Override
    public Items form(String rel) throws ClientException {
        Item me = this.toItem((Element)this.jsoupDocument);
        return me.form(rel);
    }

    @Override
    public Items item(String rel) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (Item i : this.items()) {
            if (!((ItemImpl)i).el.hasClass(rel)) continue;
            items.add(i);
        }
        return new ItemsImpl(items);
    }

    @Override
    public Items items() {
        return new ItemsImpl(this.selectItems((Element)this.jsoupDocument, new ArrayList<Item>()));
    }

    public String toString() {
        return this.jsoupDocument.toString();
    }

    private String toClass(String name) {
        return "." + name;
    }

    private List<Item> toItems(Elements el) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (Element e : el) {
            items.add(this.toItem(e));
        }
        return items;
    }

    private Item toItem(Element el) {
        return new ItemImpl(el, this);
    }

    private List<Item> selectItems(Element e, List<Item> items) {
        if (e.hasAttr("itemscope") && !e.hasAttr("itemprop")) {
            items.add(new ItemImpl(e, this));
            return items;
        }
        for (Element c : e.children()) {
            this.selectItems(c, items);
        }
        return items;
    }

    private class ItemsImpl
    implements Items {
        private List<Item> items;

        public ItemsImpl(List<Item> items) {
            this.items = items;
        }

        @Override
        public Iterator<Item> iterator() {
            return this.items.iterator();
        }

        @Override
        public Item at(int index) {
            return this.items.get(index);
        }

        @Override
        public int length() {
            return this.items.size();
        }

        @Override
        public Items prop(String name) throws ClientException {
            return this.items.get(0).prop(name);
        }

        @Override
        public Set<String> props() throws ClientException {
            return this.items.get(0).props();
        }

        @Override
        public Items link(String rel) throws ClientException {
            return this.items.get(0).link(rel);
        }

        @Override
        public Items link() throws ClientException {
            return this.items.get(0).link();
        }

        @Override
        public Items form(String rel) throws ClientException {
            return this.items.get(0).form(rel);
        }

        @Override
        public Items form() throws ClientException {
            return this.items.get(0).form();
        }

        @Override
        public String text() throws ClientException {
            return this.items.get(0).text();
        }

        @Override
        public boolean bool() throws ClientException {
            return this.items.get(0).bool();
        }

        @Override
        public int number() throws ClientException {
            return this.items.get(0).number();
        }

        @Override
        public String href() {
            return this.items.get(0).href();
        }

        @Override
        public String src() {
            return this.items.get(0).src();
        }

        @Override
        public Document follow() throws ClientException {
            return this.items.get(0).follow();
        }

        @Override
        public Document submit(Iterable<NameValuePair> values) throws ClientException {
            return this.items.get(0).submit(values);
        }
    }

    private class ItemImpl
    implements Item {
        private Element el;
        private MicrodataDocument document;
        private ItemImpl followed;

        public ItemImpl(Element element, MicrodataDocument document) {
            if (element == null) {
                throw new NullPointerException("element is mandatory");
            }
            this.el = element;
            this.document = document;
        }

        @Override
        public Items prop(String name) throws ClientException {
            return new ItemsImpl(this.selectProps(this.getProxy().el, name, new ArrayList<Item>()));
        }

        @Override
        public Set<String> props() throws ClientException {
            return this.selectAllPropNames(this.getProxy().el, new HashSet<String>());
        }

        @Override
        public Items link(String rel) throws ClientException {
            String selector = "link[rel=" + rel + "], a[rel=" + rel + "], link" + MicrodataDocument.this.toClass(rel) + ", a" + MicrodataDocument.this.toClass(rel);
            return new ItemsImpl(MicrodataDocument.this.toItems(this.getProxy().el.select(selector)));
        }

        @Override
        public Items link() throws ClientException {
            String selector = "link, a";
            return new ItemsImpl(MicrodataDocument.this.toItems(this.getProxy().el.select(selector)));
        }

        @Override
        public Items form(String rel) throws ClientException {
            String selector = "form[data-rel=" + rel + "], form" + MicrodataDocument.this.toClass(rel);
            return new ItemsImpl(MicrodataDocument.this.toItems(this.getProxy().el.select(selector)));
        }

        @Override
        public Items form() throws ClientException {
            String selector = "form";
            return new ItemsImpl(MicrodataDocument.this.toItems(this.getProxy().el.select(selector)));
        }

        private List<Item> selectProps(Element e, String name, List<Item> items) {
            for (Element c : e.children()) {
                if (c.hasAttr("itemprop")) {
                    if (c.attr("itemprop").equals(name)) {
                        items.add(new ItemImpl(c, this.document));
                    }
                    if (c.hasAttr("itemscope")) continue;
                }
                this.selectProps(c, name, items);
            }
            return items;
        }

        private Set<String> selectAllPropNames(Element e, Set<String> items) {
            for (Element c : e.children()) {
                if (c.hasAttr("itemprop")) {
                    items.add(c.attr("itemprop"));
                }
                if (c.hasAttr("itemscope")) continue;
                this.selectAllPropNames(c, items);
            }
            return items;
        }

        private ItemImpl getProxy() throws ClientException {
            if (this.el.tagName().equalsIgnoreCase("a") && this.el.hasAttr("href")) {
                if (this.followed == null) {
                    this.followed = this.follow(this.el, this.document);
                }
                return this.followed;
            }
            return this;
        }

        private ItemImpl follow(Element el, MicrodataDocument doc) throws ClientException {
            if (el.hasAttr("itemscope")) {
                return new ItemImpl(el, doc);
            }
            if (el.tagName().equalsIgnoreCase("a") && el.hasAttr("href")) {
                String href = el.attr("href");
                if (href.startsWith("#")) {
                    Element first = el.ownerDocument().select(href).first();
                    return first == null ? null : this.follow(first, doc);
                }
                String absHref = el.attr("abs:href");
                MicrodataDocument d = (MicrodataDocument)doc.client.get(absHref);
                try {
                    URI uri = new URI(absHref);
                    String fragment = uri.getRawFragment();
                    if (fragment != null) {
                        Element e = d.jsoupDocument.getElementById(fragment);
                        return e == null ? null : this.follow(e, d);
                    }
                }
                catch (URISyntaxException ex) {
                    throw new ClientException("Error parsing URI: " + absHref, ex);
                }
                ItemsImpl items = (ItemsImpl)d.items();
                if (items.length() == 1) {
                    return (ItemImpl)items.at(0);
                }
                throw new ClientException("Unable determine item: " + absHref);
            }
            return new ItemImpl(el, doc);
        }

        @Override
        public String text() throws ClientException {
            Element el = this.getProxy().el;
            if (el.tagName().equalsIgnoreCase("meta") && el.hasAttr("content")) {
                return el.attr("content");
            }
            return this.getProxy().el.text();
        }

        @Override
        public boolean bool() throws ClientException {
            return Boolean.parseBoolean(this.text());
        }

        @Override
        public int number() throws ClientException {
            return Integer.parseInt(this.text());
        }

        @Override
        public String href() {
            return this.el.attr("href");
        }

        @Override
        public String src() {
            return this.el.attr("src");
        }

        @Override
        public Document follow() throws ClientException {
            if ((this.el.tagName().equalsIgnoreCase("a") || this.el.tagName().equalsIgnoreCase("link")) && this.el.hasAttr("href")) {
                String href = this.el.attr("href");
                if (href.startsWith("#")) {
                    return this.document;
                }
                return this.document.client.enter(this.el.attr("abs:href"));
            }
            throw new ClientException("Unable to follow: " + this.el.toString());
        }

        @Override
        public Document submit(Iterable<NameValuePair> values) throws ClientException {
            if (this.el.tagName().equalsIgnoreCase("form")) {
                String method;
                String action = this.el.attr("abs:action");
                if (action.length() == 0) {
                    action = this.el.baseUri();
                }
                if ((method = this.el.attr("method")).length() == 0 || method.equalsIgnoreCase("get")) {
                    FormValues query = new FormValues(this.el, values);
                    String url = action + (action.contains("?") ? "?" : "&") + query.toString();
                    return this.document.client.enter(url);
                }
                if (method.equalsIgnoreCase("post")) {
                    String enctype = this.el.attr("enctype");
                    FormValues v = new FormValues(this.el, values);
                    if (enctype.length() == 0 || enctype.equalsIgnoreCase("application/x-www-form-urlencoded")) {
                        return this.document.client.post(action, v.toUrlEncodedEntity());
                    }
                    if (enctype.equalsIgnoreCase("multipart/form-data")) {
                        return this.document.client.post(action, v.toMultipartEntity());
                    }
                    throw new ClientException("Unsupported form enctype: " + enctype);
                }
                throw new ClientException("Unsupported form method: " + method);
            }
            throw new ClientException("The item is not a form");
        }
    }
}

