/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resource.collection.impl;

import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.resource.collection.ResourceCollection;
import org.apache.sling.resource.collection.ResourceCollectionManager;
import org.apache.sling.resource.collection.impl.ResourceCollectionImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AdapterFactory.class}, property={"service.vendor=The Apache Software Foundation", "service.description=Apache Sling Resource Collection Adapter Factory", "adapters=org.apache.sling.resource.collection.ResourceCollection", "adapters=org.apache.sling.resource.collection.ResourceCollectionManager", "adaptables=org.apache.sling.api.resource.Resource", "adaptables=org.apache.sling.api.resource.ResourceResolver"})
public class ResourceCollectionAdapterFactory
implements AdapterFactory {
    private final Logger log = LoggerFactory.getLogger(ResourceCollectionAdapterFactory.class);
    private static final Class<ResourceCollection> COLLECTION_CLASS = ResourceCollection.class;
    private static final Class<ResourceCollectionManager> COLLECTION_MGR_CLASS = ResourceCollectionManager.class;
    @Reference
    private ResourceCollectionManager collectionManager;

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (adaptable instanceof Resource) {
            return this.getAdapter((Resource)adaptable, type);
        }
        if (adaptable instanceof ResourceResolver) {
            return this.getAdapter((ResourceResolver)adaptable, type);
        }
        this.log.warn("Unable to handle adaptable {}", (Object)adaptable.getClass().getName());
        return null;
    }

    private <AdapterType> AdapterType getAdapter(Resource resource, Class<AdapterType> type) {
        if (resource != null) {
            if (type == COLLECTION_CLASS && resource.isResourceType("sling/collection")) {
                return (AdapterType)new ResourceCollectionImpl(resource);
            }
            this.log.debug("Unable to adapt resource of {} to type {}", (Object)resource.getResourceType(), (Object)type.getName());
        }
        this.log.debug("Unable to adapt null resource to type {}", (Object)type.getName());
        return null;
    }

    private <AdapterType> AdapterType getAdapter(ResourceResolver resolver, Class<AdapterType> type) {
        if (COLLECTION_MGR_CLASS == type) {
            return (AdapterType)this.collectionManager;
        }
        this.log.warn("Unable to adapt resolver to requested type {}", (Object)type.getName());
        return null;
    }
}

