/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlethelpers.internalrequests;

import jakarta.servlet.ServletException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.servlethelpers.MockRequestPathInfo;
import org.apache.sling.servlethelpers.MockSlingJakartaHttpServletRequest;
import org.apache.sling.servlethelpers.MockSlingJakartaHttpServletResponse;
import org.apache.sling.servlethelpers.internalrequests.BaseInternalRequest;
import org.jetbrains.annotations.NotNull;
import org.slf4j.MDC;

public abstract class JakartaInternalRequest
extends BaseInternalRequest {
    private MockSlingJakartaHttpServletRequest request;
    private MockSlingJakartaHttpServletResponse response;

    protected JakartaInternalRequest(@NotNull ResourceResolver resourceResolver, @NotNull String path) {
        super(resourceResolver, path);
    }

    @Override
    public JakartaInternalRequest withRequestMethod(String method) {
        return (JakartaInternalRequest)super.withRequestMethod(method);
    }

    @Override
    public JakartaInternalRequest withContentType(String contentType) {
        return (JakartaInternalRequest)super.withContentType(contentType);
    }

    @Override
    public JakartaInternalRequest withBody(Reader bodyContent) {
        return (JakartaInternalRequest)super.withBody(bodyContent);
    }

    @Override
    public JakartaInternalRequest withSelectors(String ... selectors) {
        return (JakartaInternalRequest)super.withSelectors(selectors);
    }

    @Override
    public JakartaInternalRequest withExtension(String extension) {
        return (JakartaInternalRequest)super.withExtension(extension);
    }

    @Override
    public JakartaInternalRequest withParameter(String key, Object value) {
        return (JakartaInternalRequest)super.withParameter(key, value);
    }

    @Override
    public JakartaInternalRequest withParameters(Map<String, Object> additionalParameters) {
        return (JakartaInternalRequest)super.withParameters(additionalParameters);
    }

    @Override
    public final JakartaInternalRequest execute() throws IOException {
        if (this.request != null) {
            throw new IOException("Request was already executed");
        }
        Resource resource = this.getExecutionResource();
        this.request = new MockSlingJakartaHttpServletRequest(this.resourceResolver){

            @Override
            protected MockRequestPathInfo newMockRequestPathInfo() {
                MockRequestPathInfo rpi = super.newMockRequestPathInfo();
                rpi.setResourcePath(JakartaInternalRequest.this.path);
                rpi.setExtension(JakartaInternalRequest.this.extension);
                rpi.setSelectorString(JakartaInternalRequest.this.selectorString);
                return rpi;
            }

            @Override
            public BufferedReader getReader() {
                if (JakartaInternalRequest.this.bodyReader != null) {
                    return new BufferedReader(JakartaInternalRequest.this.bodyReader);
                }
                return super.getReader();
            }
        };
        this.request.setMethod(this.requestMethod);
        this.request.setContentType(this.contentType);
        this.request.setResource(resource);
        this.request.setParameterMap(this.parameters);
        this.response = new MockSlingJakartaHttpServletResponse();
        MDC.put((String)MDC_KEY, (String)this.toString());
        try {
            this.delegateExecute(this.request, this.response, this.resourceResolver);
        }
        catch (ServletException sx) {
            throw new IOException("ServletException in execute()", sx);
        }
        return this;
    }

    protected abstract void delegateExecute(SlingJakartaHttpServletRequest var1, SlingJakartaHttpServletResponse var2, ResourceResolver var3) throws ServletException, IOException;

    @Override
    protected void assertRequestExecuted() throws IOException {
        if (this.request == null) {
            throw new IOException("Request hasn't been executed");
        }
    }

    @Override
    public JakartaInternalRequest checkStatus(int ... acceptableValues) throws IOException {
        return (JakartaInternalRequest)super.checkStatus(acceptableValues);
    }

    private void maybeCheckOkStatus() throws IOException {
        if (!this.explicitStatusCheck) {
            try {
                this.checkStatus(200);
            }
            finally {
                this.explicitStatusCheck = false;
            }
        }
    }

    @Override
    public JakartaInternalRequest checkResponseContentType(String contentType) throws IOException {
        this.assertRequestExecuted();
        if (!contentType.equals(this.response.getContentType())) {
            throw new IOException("Expected content type " + contentType + " but got " + this.response.getContentType());
        }
        return this;
    }

    @Override
    public int getStatus() throws IOException {
        this.assertRequestExecuted();
        return this.response.getStatus();
    }

    public SlingJakartaHttpServletResponse getResponse() throws IOException {
        this.assertRequestExecuted();
        this.maybeCheckOkStatus();
        return this.response;
    }

    @Override
    public String getResponseAsString() throws IOException {
        this.assertRequestExecuted();
        this.maybeCheckOkStatus();
        return this.response.getOutputAsString();
    }
}

