/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.startup.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(StartupFilter.class);
    private String content;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StartupFilter() {
        InputStream is = StartupFilter.class.getClassLoader().getResourceAsStream("index.html");
        if (is != null) {
            BufferedReader buffer = null;
            try {
                buffer = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                this.content = buffer.lines().collect(Collectors.joining(System.lineSeparator()));
            }
            finally {
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (IOException e) {
                        LOG.error("Unable to release resource.", (Throwable)e);
                    }
                }
            }
        }
        if (this.content == null || "".equals(this.content)) {
            this.content = "<html><head><meta http-equiv=\"refresh\" content=\"5\"><title>Apache Sling</title></head><body><h1>Apache Sling is starting up....</h1></body></html>";
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setContentType("text/html");
        httpResponse.setCharacterEncoding("utf-8");
        httpResponse.setHeader("Cache-Control", "no-store");
        httpResponse.setStatus(503);
        if (!"".equals(this.content) && this.content != null) {
            PrintWriter pw = response.getWriter();
            pw.append(this.content);
            pw.flush();
        }
    }

    public void destroy() {
    }
}

