/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.codegen.cplan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.sysds.hops.codegen.SpoofCompiler;
import org.apache.sysds.hops.codegen.SpoofFusedOp;
import org.apache.sysds.hops.codegen.cplan.CNode;
import org.apache.sysds.hops.codegen.cplan.CNodeBinary;
import org.apache.sysds.hops.codegen.cplan.CNodeData;

public abstract class CNodeTpl
extends CNode
implements Cloneable {
    private int _beginLine = -1;
    protected SpoofCompiler.GeneratorAPI api = SpoofCompiler.GeneratorAPI.AUTO;

    public CNodeTpl(ArrayList<CNode> inputs, CNode output) {
        if (inputs.size() < 1) {
            throw new RuntimeException("Cannot pass empty inputs to the CNodeTpl");
        }
        for (CNode input : inputs) {
            this.addInput(input);
        }
        this._output = output;
    }

    public void addInput(CNode in) {
        if (this.containsInput(in) || in.isLiteral()) {
            return;
        }
        this._inputs.add(in);
    }

    public String[] getInputNames() {
        String[] ret = new String[this._inputs.size()];
        for (int i = 0; i < this._inputs.size(); ++i) {
            ret[i] = ((CNode)this._inputs.get(i)).getVarname();
        }
        return ret;
    }

    public HashSet<Long> getInputHopIDs(boolean inclLiterals) {
        HashSet<Long> ret = new HashSet<Long>();
        for (CNode input : this._inputs) {
            if (input.isLiteral() && !inclLiterals) continue;
            ret.add(((CNodeData)input).getHopID());
        }
        return ret;
    }

    public void resetVisitStatusOutputs() {
        this.getOutput().resetVisitStatus();
    }

    public static void resetVisitStatus(List<CNode> outputs) {
        for (CNode output : outputs) {
            output.resetVisitStatus();
        }
    }

    public String codegen() {
        return this.codegen(false, SpoofCompiler.GeneratorAPI.AUTO);
    }

    public abstract CNodeTpl clone();

    public abstract SpoofFusedOp.SpoofOutputDimsType getOutputDimType();

    public abstract String getTemplateInfo();

    public abstract void renameInputs();

    protected void renameInputs(ArrayList<CNode> inputs, int startIndex) {
        this.renameInputs(Collections.singletonList(this._output), inputs, startIndex);
    }

    protected void renameInputs(List<CNode> outputs, ArrayList<CNode> inputs, int startIndex) {
        HashMap<Long, String> newNames = new HashMap<Long, String>();
        int sPos = 0;
        int mPos = 0;
        for (int i = startIndex; i < inputs.size(); ++i) {
            CNode cnode = inputs.get(i);
            if (cnode instanceof CNodeData && ((CNodeData)cnode).isLiteral()) continue;
            newNames.put(((CNodeData)cnode).getHopID(), cnode.getDataType().isScalar() ? "scalars[" + mPos++ + "]" : "b[" + sPos++ + "]");
        }
        CNodeTpl.resetVisitStatus(outputs);
        for (CNode output : outputs) {
            this.rRenameDataNodes(output, newNames);
        }
    }

    protected void rRenameDataNode(CNode root, CNode input, String newName) {
        this.rRenameDataNode(Collections.singletonList(root), input, newName);
    }

    protected void rRenameDataNode(List<CNode> roots, CNode input, String newName) {
        if (!(input instanceof CNodeData)) {
            return;
        }
        HashMap<Long, String> newNames = new HashMap<Long, String>();
        newNames.put(((CNodeData)input).getHopID(), newName);
        CNodeTpl.resetVisitStatus(roots);
        for (CNode root : roots) {
            this.rRenameDataNodes(root, newNames);
        }
    }

    protected void rRenameDataNodes(CNode node, HashMap<Long, String> newNames) {
        CNodeData dnode;
        if (node.isVisited()) {
            return;
        }
        for (CNode c : node.getInput()) {
            this.rRenameDataNodes(c, newNames);
        }
        if (node instanceof CNodeData && newNames.containsKey((dnode = (CNodeData)node).getHopID())) {
            dnode.setName(newNames.get(dnode.getHopID()));
        }
        node.resetHash();
        node.setVisited();
    }

    public void rReorderCommutativeBinaryOps(CNode node, long mainHopID) {
        if (this.isVisited()) {
            return;
        }
        for (CNode c : node.getInput()) {
            this.rReorderCommutativeBinaryOps(c, mainHopID);
        }
        if (node instanceof CNodeBinary && node.getInput().get(1) instanceof CNodeData && ((CNodeData)node.getInput().get(1)).getHopID() == mainHopID && ((CNodeBinary)node).getType().isCommutative()) {
            CNode tmp = node.getInput().get(0);
            node.getInput().set(0, node.getInput().get(1));
            node.getInput().set(1, tmp);
        }
        this.setVisited();
    }

    private boolean containsInput(CNode input) {
        if (!(input instanceof CNodeData)) {
            return false;
        }
        CNodeData input2 = (CNodeData)input;
        for (CNode cnode : this._inputs) {
            if (!(cnode instanceof CNodeData)) continue;
            CNodeData cnode2 = (CNodeData)cnode;
            if (!cnode2._name.equals(input2._name) || cnode2._hopID != input2._hopID) continue;
            return true;
        }
        return false;
    }

    public void setBeginLine(int line) {
        this._beginLine = line;
    }

    public int getBeginLine() {
        return this._beginLine;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof CNodeTpl && super.equals(o);
    }

    protected static boolean equalInputReferences(CNode current1, CNode current2, ArrayList<CNode> input1, ArrayList<CNode> input2) {
        boolean ret = current1.getInput().size() == current2.getInput().size();
        for (int i = 0; ret && i < current1.getInput().size(); ret &= CNodeTpl.equalInputReferences(current1.getInput().get(i), current2.getInput().get(i), input1, input2), ++i) {
        }
        if (ret && current1 instanceof CNodeData) {
            ret &= current2 instanceof CNodeData && CNodeTpl.indexOf(input1, (CNodeData)current1) == CNodeTpl.indexOf(input2, (CNodeData)current2);
        }
        return ret;
    }

    protected static boolean equalInputReferences(ArrayList<CNode> current1, ArrayList<CNode> current2, ArrayList<CNode> input1, ArrayList<CNode> input2) {
        boolean ret = current1.size() == current2.size();
        for (int i = 0; ret && i < current1.size(); ret &= CNodeTpl.equalInputReferences(current1.get(i), current2.get(i), input1, input2), ++i) {
        }
        return ret;
    }

    private static int indexOf(ArrayList<CNode> inputs, CNodeData probe) {
        for (int i = 0; i < inputs.size(); ++i) {
            CNodeData cd = (CNodeData)inputs.get(i);
            if (cd.getHopID() != probe.getHopID()) continue;
            return i;
        }
        return -1;
    }

    public SpoofCompiler.GeneratorAPI getGeneratorAPI() {
        return this.api;
    }

    public void setGeneratorAPI(SpoofCompiler.GeneratorAPI _api) {
        this.api = _api;
    }

    public abstract int compile(SpoofCompiler.GeneratorAPI var1, String var2);
}

