/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.broadcast.Broadcast;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.spark.BinarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;
import scala.Tuple2;

public class BinaryFrameFrameSPInstruction
extends BinarySPInstruction {
    protected BinaryFrameFrameSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(SPInstruction.SPType.Binary, op, in1, in2, out, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        JavaPairRDD<Long, FrameBlock> in1 = sec.getFrameBinaryBlockRDDHandleForVariable(this.input1.getName());
        JavaPairRDD out = null;
        if (this.getOpcode().equals("dropInvalidType")) {
            Broadcast fb = sec.getSparkContext().broadcast((Object)sec.getFrameInput(this.input2.getName()));
            out = in1.mapValues((Function)new isCorrectbySchema((FrameBlock)fb.getValue()));
            sec.releaseFrameInput(this.input2.getName());
        } else if (this.getOpcode().equals("valueSwap")) {
            Broadcast fb = sec.getSparkContext().broadcast((Object)sec.getFrameInput(this.input2.getName()));
            out = in1.mapValues((Function)new valueSwapBySchema((FrameBlock)fb.getValue()));
            sec.releaseFrameInput(this.input2.getName());
        } else {
            JavaPairRDD<Long, FrameBlock> in2 = sec.getFrameBinaryBlockRDDHandleForVariable(this.input2.getName());
            BinaryOperator dop = (BinaryOperator)this._optr;
            out = in1.join(in2).mapValues((Function)new FrameComparison(dop));
        }
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
        if (!this.getOpcode().equals("dropInvalidType") && !this.getOpcode().equals("valueSwap")) {
            sec.addLineageRDD(this.output.getName(), this.input2.getName());
        }
    }

    private static class valueSwapBySchema
    implements Function<FrameBlock, FrameBlock> {
        private static final long serialVersionUID = 5850400295183766402L;
        private FrameBlock schema_frame;

        public valueSwapBySchema(FrameBlock fb_name) {
            this.schema_frame = fb_name;
        }

        public FrameBlock call(FrameBlock arg0) throws Exception {
            return arg0.valueSwap(this.schema_frame);
        }
    }

    private static class FrameComparison
    implements Function<Tuple2<FrameBlock, FrameBlock>, FrameBlock> {
        private static final long serialVersionUID = 5850400295183766401L;
        private final BinaryOperator bop;

        public FrameComparison(BinaryOperator op) {
            this.bop = op;
        }

        public FrameBlock call(Tuple2<FrameBlock, FrameBlock> arg0) throws Exception {
            return ((FrameBlock)arg0._1()).binaryOperations(this.bop, (FrameBlock)arg0._2(), null);
        }
    }

    private static class isCorrectbySchema
    implements Function<FrameBlock, FrameBlock> {
        private static final long serialVersionUID = 5850400295183766400L;
        private FrameBlock schema_frame;

        public isCorrectbySchema(FrameBlock fb_name) {
            this.schema_frame = fb_name;
        }

        public FrameBlock call(FrameBlock arg0) throws Exception {
            return arg0.dropInvalidType(this.schema_frame);
        }
    }
}

