/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.CompilerConfig;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.io.ReaderCompressed;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysds.runtime.io.FileFormatPropertiesHDF5;
import org.apache.sysds.runtime.io.FileFormatPropertiesLIBSVM;
import org.apache.sysds.runtime.io.MatrixReader;
import org.apache.sysds.runtime.io.ReadProperties;
import org.apache.sysds.runtime.io.ReaderBinaryBlock;
import org.apache.sysds.runtime.io.ReaderBinaryBlockParallel;
import org.apache.sysds.runtime.io.ReaderHDF5;
import org.apache.sysds.runtime.io.ReaderHDF5Parallel;
import org.apache.sysds.runtime.io.ReaderTextCSV;
import org.apache.sysds.runtime.io.ReaderTextCSVParallel;
import org.apache.sysds.runtime.io.ReaderTextCell;
import org.apache.sysds.runtime.io.ReaderTextCellParallel;
import org.apache.sysds.runtime.io.ReaderTextLIBSVM;
import org.apache.sysds.runtime.io.ReaderTextLIBSVMParallel;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class MatrixReaderFactory {
    private static final Log LOG = LogFactory.getLog((String)MatrixReaderFactory.class.getName());

    public static MatrixReader createMatrixReader(Types.FileFormat fmt) {
        boolean mcsr;
        MatrixReader reader = null;
        boolean par = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS);
        boolean bl = mcsr = MatrixBlock.DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("reading parallel: " + par + " mcsr: " + mcsr));
        }
        switch (fmt) {
            case TEXT: 
            case MM: {
                reader = par & mcsr ? new ReaderTextCellParallel(fmt) : new ReaderTextCell(fmt);
                break;
            }
            case CSV: {
                reader = par & mcsr ? new ReaderTextCSVParallel(new FileFormatPropertiesCSV()) : new ReaderTextCSV(new FileFormatPropertiesCSV());
                break;
            }
            case LIBSVM: {
                reader = par & mcsr ? new ReaderTextLIBSVMParallel(new FileFormatPropertiesLIBSVM()) : new ReaderTextLIBSVM(new FileFormatPropertiesLIBSVM());
                break;
            }
            case BINARY: {
                reader = par & mcsr ? new ReaderBinaryBlockParallel(false) : new ReaderBinaryBlock(false);
                break;
            }
            case HDF5: {
                reader = par & mcsr ? new ReaderHDF5Parallel(new FileFormatPropertiesHDF5()) : new ReaderHDF5(new FileFormatPropertiesHDF5());
                break;
            }
            case COMPRESSED: {
                reader = ReaderCompressed.create();
                break;
            }
            default: {
                throw new DMLRuntimeException("Failed to create matrix reader for unknown format: " + fmt.toString());
            }
        }
        return reader;
    }

    public static MatrixReader createMatrixReader(ReadProperties props) {
        boolean mcsr;
        if (props == null) {
            throw new DMLRuntimeException("Failed to create matrix reader with empty properties.");
        }
        MatrixReader reader = null;
        Types.FileFormat fmt = props.fmt;
        boolean par = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS);
        boolean bl = mcsr = MatrixBlock.DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("reading parallel: " + par + " mcsr: " + mcsr));
        }
        switch (fmt) {
            case TEXT: 
            case MM: {
                reader = par & mcsr ? new ReaderTextCellParallel(fmt) : new ReaderTextCell(fmt);
                break;
            }
            case CSV: {
                reader = par & mcsr ? new ReaderTextCSVParallel(props.formatProperties != null ? (FileFormatPropertiesCSV)props.formatProperties : new FileFormatPropertiesCSV()) : new ReaderTextCSV(props.formatProperties != null ? (FileFormatPropertiesCSV)props.formatProperties : new FileFormatPropertiesCSV());
                break;
            }
            case LIBSVM: {
                FileFormatPropertiesLIBSVM fileFormatPropertiesLIBSVM = props.formatProperties != null ? (FileFormatPropertiesLIBSVM)props.formatProperties : new FileFormatPropertiesLIBSVM();
                reader = par & mcsr ? new ReaderTextLIBSVMParallel(fileFormatPropertiesLIBSVM) : new ReaderTextLIBSVM(fileFormatPropertiesLIBSVM);
                break;
            }
            case BINARY: {
                reader = par & mcsr ? new ReaderBinaryBlockParallel(props.localFS) : new ReaderBinaryBlock(props.localFS);
                break;
            }
            case HDF5: {
                FileFormatPropertiesHDF5 fileFormatPropertiesHDF5 = props.formatProperties != null ? (FileFormatPropertiesHDF5)props.formatProperties : new FileFormatPropertiesHDF5();
                reader = par & mcsr ? new ReaderHDF5Parallel(fileFormatPropertiesHDF5) : new ReaderHDF5(fileFormatPropertiesHDF5);
                break;
            }
            case COMPRESSED: {
                reader = new ReaderCompressed();
                break;
            }
            default: {
                throw new DMLRuntimeException("Failed to create matrix reader for unknown format: " + fmt.toString());
            }
        }
        return reader;
    }
}

