/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.tapestry5.json.JSON;
import org.apache.tapestry5.json.JSONCollection;
import org.apache.tapestry5.json.JSONExceptionBuilder;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.json.JSONPrintSession;
import org.apache.tapestry5.json.JSONTokener;
import org.apache.tapestry5.json.JSONType;
import org.apache.tapestry5.json.exceptions.JSONArrayIndexOutOfBoundsException;

public final class JSONArray
extends JSONCollection
implements Collection<Object> {
    private static final long serialVersionUID = 1L;
    private final List<Object> values;

    public JSONArray() {
        this.values = new ArrayList<Object>();
    }

    JSONArray(JSONTokener readFrom) {
        Object object = readFrom.nextValue(JSONArray.class);
        if (!(object instanceof JSONArray)) {
            throw JSONExceptionBuilder.tokenerTypeMismatch(object, JSONType.ARRAY);
        }
        this.values = ((JSONArray)object).values;
    }

    public JSONArray(String json) {
        this(new JSONTokener(json));
    }

    public JSONArray(Object ... values) {
        this();
        for (int i = 0; i < values.length; ++i) {
            this.checkedPut(values[i]);
        }
    }

    public static JSONArray from(Iterable<?> iterable) {
        return new JSONArray().putAll(iterable);
    }

    public int length() {
        return this.size();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public JSONArray put(Object value) {
        this.add(value);
        return this;
    }

    @Override
    public boolean add(Object value) {
        JSON.testValidity(value);
        return this.values.add(value);
    }

    void checkedPut(Object value) {
        JSON.testValidity(value);
        if (value instanceof Number) {
            JSON.checkDouble(((Number)value).doubleValue());
        }
        this.put(value);
    }

    public JSONArray put(int index, Object value) {
        if (index < 0) {
            throw new JSONArrayIndexOutOfBoundsException(index);
        }
        JSON.testValidity(value);
        if (value instanceof Number) {
            JSON.checkDouble(((Number)value).doubleValue());
        }
        while (this.values.size() <= index) {
            this.values.add(null);
        }
        this.values.set(index, value);
        return this;
    }

    public boolean isNull(int index) {
        Object value = this.values.get(index);
        return value == null || value == JSONObject.NULL;
    }

    public Object get(int index) {
        try {
            Object value = this.values.get(index);
            if (value == null) {
                throw JSONExceptionBuilder.valueNotFound(true, index, JSONType.ANY);
            }
            return value;
        }
        catch (IndexOutOfBoundsException e) {
            throw new JSONArrayIndexOutOfBoundsException(index);
        }
    }

    public Object remove(int index) {
        if (index < 0 || index >= this.values.size()) {
            return null;
        }
        return this.values.remove(index);
    }

    @Override
    public boolean remove(Object value) {
        return this.values.remove(value);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.values.removeAll(collection);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.values.retainAll(collection);
    }

    public boolean getBoolean(int index) {
        Object object = this.get(index);
        Boolean result = JSON.toBoolean(object);
        if (result == null) {
            throw JSONExceptionBuilder.typeMismatch(true, index, object, JSONType.BOOLEAN);
        }
        return result;
    }

    public double getDouble(int index) {
        Object object = this.get(index);
        Double result = JSON.toDouble(object);
        if (result == null) {
            throw JSONExceptionBuilder.typeMismatch(true, index, object, JSONType.NUMBER);
        }
        return result;
    }

    public int getInt(int index) {
        Object object = this.get(index);
        Integer result = JSON.toInteger(object);
        if (result == null) {
            throw JSONExceptionBuilder.typeMismatch(true, index, object, JSONType.NUMBER);
        }
        return result;
    }

    public long getLong(int index) {
        Object object = this.get(index);
        Long result = JSON.toLong(object);
        if (result == null) {
            throw JSONExceptionBuilder.typeMismatch(true, index, object, JSONType.NUMBER);
        }
        return result;
    }

    public String getString(int index) {
        Object object = this.get(index);
        String result = JSON.toString(object);
        if (result == null) {
            throw JSONExceptionBuilder.typeMismatch(true, index, object, JSONType.STRING);
        }
        return result;
    }

    public JSONArray getJSONArray(int index) {
        Object object = this.get(index);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw JSONExceptionBuilder.typeMismatch(true, index, object, JSONType.ARRAY);
    }

    public JSONObject getJSONObject(int index) {
        Object object = this.get(index);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw JSONExceptionBuilder.typeMismatch(true, index, object, JSONType.OBJECT);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof JSONArray && ((JSONArray)o).values.equals(this.values);
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    void print(JSONPrintSession session) {
        session.printSymbol('[');
        session.indent();
        boolean comma = false;
        for (Object value : this.values) {
            if (comma) {
                session.printSymbol(',');
            }
            session.newline();
            JSONObject.printValue(session, value);
            comma = true;
        }
        session.outdent();
        if (comma) {
            session.newline();
        }
        session.printSymbol(']');
    }

    public JSONArray putAll(Iterable<?> collection) {
        if (collection != null) {
            for (Object o : collection) {
                this.put(o);
            }
        }
        return this;
    }

    @Override
    public boolean addAll(Collection<? extends Object> collection) {
        if (collection == null) {
            return false;
        }
        boolean changed = false;
        for (Object object : collection) {
            changed = this.add(object) || changed;
        }
        return changed;
    }

    public List<Object> toList() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public Object[] toArray() {
        return this.values.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.values.toArray(array);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.values.iterator();
    }

    @Override
    public boolean contains(Object value) {
        return this.values.contains(value);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.values.containsAll(c);
    }
}

