/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client.security;

import java.security.cert.X509Certificate;
import java.util.List;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.CertificateValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ClientCertificateValidator
extends CertificateValidator {
    public void validateCertificateChain(List<X509Certificate> var1, String var2, String ... var3) throws UaException;

    public static class InsecureValidator
    implements ClientCertificateValidator {
        private static final Logger LOGGER = LoggerFactory.getLogger(InsecureValidator.class);

        @Override
        public void validateCertificateChain(List<X509Certificate> certificateChain, String applicationUri, String ... validHostNames) {
            X509Certificate certificate = certificateChain.get(0);
            LOGGER.warn("Skipping validation for certificate: {}", (Object)certificate.getSubjectX500Principal());
        }

        public void validateCertificateChain(List<X509Certificate> certificateChain) {
            X509Certificate certificate = certificateChain.get(0);
            LOGGER.warn("Skipping validation for certificate: {}", (Object)certificate.getSubjectX500Principal());
        }
    }
}

