/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Math3DCache;
import org.eclipse.draw3d.geometry.Math3DVector2f;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;

public class Math3DVector3f
extends Math3DVector2f {
    public static Vector3f abs(IVector3f i_source, Vector3f io_result) {
        if (io_result == null) {
            io_result = new Vector3fImpl(Math.abs(i_source.getX()), Math.abs(i_source.getY()), Math.abs(i_source.getZ()));
        } else {
            io_result.set(Math.abs(i_source.getX()), Math.abs(i_source.getY()), Math.abs(i_source.getZ()));
        }
        return io_result;
    }

    public static Vector3f add(IVector3f i_left, IVector3f i_right, Vector3f o_result) {
        if (o_result == null) {
            return new Vector3fImpl(i_left.getX() + i_right.getX(), i_left.getY() + i_right.getY(), i_left.getZ() + i_right.getZ());
        }
        o_result.set(i_left.getX() + i_right.getX(), i_left.getY() + i_right.getY(), i_left.getZ() + i_right.getZ());
        return o_result;
    }

    public static float angle(IVector3f i_left, IVector3f i_right) {
        float cosAlpha = Math3DVector3f.dot(i_left, i_right) / (i_left.length() * i_right.length());
        if (cosAlpha <= -1.0f) {
            return (float)Math.PI;
        }
        if (cosAlpha >= 1.0f) {
            return 0.0f;
        }
        return (float)Math.acos(cosAlpha);
    }

    public static Vector3f cross(IVector3f i_left, IVector3f i_right, Vector3f o_result) {
        float x = i_left.getY() * i_right.getZ() - i_left.getZ() * i_right.getY();
        float y = i_left.getZ() * i_right.getX() - i_left.getX() * i_right.getZ();
        float z = i_left.getX() * i_right.getY() - i_left.getY() * i_right.getX();
        if (o_result == null) {
            return new Vector3fImpl(x, y, z);
        }
        o_result.set(x, y, z);
        return o_result;
    }

    public static float distance(IVector3f i_v1, IVector3f i_v2) {
        float f;
        Vector3f d = Math3DCache.getVector3f();
        try {
            Math3DVector3f.sub(i_v1, i_v2, d);
            f = d.length();
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f(d);
            throw throwable;
        }
        Math3DCache.returnVector3f(d);
        return f;
    }

    public static float distanceSquared(IVector3f i_v1, IVector3f i_v2) {
        float f;
        Vector3f d = Math3DCache.getVector3f();
        try {
            Math3DVector3f.sub(i_v1, i_v2, d);
            f = d.lengthSquared();
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f(d);
            throw throwable;
        }
        Math3DCache.returnVector3f(d);
        return f;
    }

    public static float dot(IVector3f i_left, IVector3f i_right) {
        return i_left.getX() * i_right.getX() + i_left.getY() * i_right.getY() + i_left.getZ() * i_right.getZ();
    }

    public static boolean equals(IVector3f i_left, IVector3f i_right, float epsilon) {
        return Math3DVector3f.equals(i_left.getX(), i_right.getX(), epsilon) && Math3DVector3f.equals(i_left.getY(), i_right.getY(), epsilon) && Math3DVector3f.equals(i_left.getZ(), i_right.getZ(), epsilon);
    }

    public static Vector3f eulerAngles(IVector3f i_vector, IVector3f i_reference, Vector3f o_result) {
        Vector3f vector3f;
        if (i_vector == null) {
            throw new NullPointerException("i_reference must not be null");
        }
        if (i_reference == null) {
            throw new NullPointerException("i_vector must not be null");
        }
        Vector3f result = o_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        if (i_vector.equals(i_reference)) {
            result.set(0.0f, 0.0f, 0.0f);
            return result;
        }
        Vector3f axis = Math3DCache.getVector3f();
        try {
            double b;
            double a;
            double h;
            Math3D.cross(i_reference, i_vector, axis);
            double qx = axis.getX();
            double qy = axis.getY();
            double qz = axis.getZ();
            double qw = 1.0f + Math3D.dot(i_reference, i_vector);
            double qx2 = qx * qx;
            double qy2 = qy * qy;
            double qz2 = qz * qz;
            double qw2 = qw * qw;
            double t = qx * qy + qz * qw;
            double u = qx2 + qy2 + qz2 + qw2;
            if (t > 0.4999999 * u) {
                h = 2.0 * Math.atan2(qx, qw);
                a = 1.5707963267948966;
                b = 0.0;
            } else if (t < -0.4999999 * u) {
                h = -2.0 * Math.atan2(qx, qw);
                a = -1.5707963267948966;
                b = 0.0;
            } else {
                double xh = 2.0 * (qy * qw - qx * qz);
                double yh = qx2 - qy2 - qz2 + qw2;
                double xb = 2.0 * (qx * qw - qy * qz);
                double yb = -qx2 + qy2 - qz2 + qw2;
                h = Math.atan2(xh, yh);
                a = Math.asin(2.0 * t / u);
                b = Math.atan2(xb, yb);
            }
            result.set((float)b, (float)h, (float)a);
            vector3f = result;
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f(axis);
            throw throwable;
        }
        Math3DCache.returnVector3f(axis);
        return vector3f;
    }

    public static Vector3f getLocation(IVector3f i_rayOrigin, IVector3f i_rayDirection, float i_distance, Vector3f io_result) {
        Vector3f vector3f;
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        Vector3f tmp = Math3DCache.getVector3f();
        try {
            tmp.set(i_rayDirection);
            tmp.scale(i_distance);
            Math3D.add(i_rayOrigin, tmp, result);
            vector3f = result;
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f(tmp);
            throw throwable;
        }
        Math3DCache.returnVector3f(tmp);
        return vector3f;
    }

    public static Vector3f getRayDirection(IVector3f i_origin, IVector3f i_point, Vector3f o_result) {
        if (i_origin.equals(i_point)) {
            return null;
        }
        Vector3f result = o_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        Math3DVector3f.sub(i_point, i_origin, result);
        Math3DVector3f.normalise(result, result);
        return result;
    }

    public static Vector3f max(IVector3f i_v0, IVector3f i_v1, Vector3f o_result) {
        Vector3f result = o_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        result.set(Math.max(i_v0.getX(), i_v1.getX()), Math.max(i_v0.getY(), i_v1.getY()), Math.max(i_v0.getZ(), i_v1.getZ()));
        return result;
    }

    public static Vector3f min(IVector3f i_v0, IVector3f i_v1, Vector3f o_result) {
        Vector3f result = o_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        result.set(Math.min(i_v0.getX(), i_v1.getX()), Math.min(i_v0.getY(), i_v1.getY()), Math.min(i_v0.getZ(), i_v1.getZ()));
        return result;
    }

    public static Vector3f negate(IVector3f i_source, Vector3f o_result) {
        if (o_result == null) {
            return new Vector3fImpl(-i_source.getX(), -i_source.getY(), -i_source.getZ());
        }
        o_result.set(-i_source.getX(), -i_source.getY(), -i_source.getZ());
        return o_result;
    }

    public static Vector3f normalise(IVector3f i_source, Vector3f o_result) {
        float lengthInv = 1.0f / i_source.length();
        return Math3DVector3f.scale(lengthInv, i_source, o_result);
    }

    public static Vector3f scale(float scale, IVector3f i_source, Vector3f o_result) {
        if (o_result == null) {
            return new Vector3fImpl(scale * i_source.getX(), scale * i_source.getY(), scale * i_source.getZ());
        }
        o_result.set(scale * i_source.getX(), scale * i_source.getY(), scale * i_source.getZ());
        return o_result;
    }

    public static Vector3f scale(IVector3f i_scale, IVector3f i_source, Vector3f o_result) {
        Vector3f result = o_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        result.setX(i_scale.getX() * i_source.getX());
        result.setY(i_scale.getY() * i_source.getY());
        result.setZ(i_scale.getZ() * i_source.getZ());
        return result;
    }

    public static Vector3f sub(IVector3f i_left, IVector3f i_right, Vector3f o_result) {
        if (o_result == null) {
            return new Vector3fImpl(i_left.getX() - i_right.getX(), i_left.getY() - i_right.getY(), i_left.getZ() - i_right.getZ());
        }
        o_result.set(i_left.getX() - i_right.getX(), i_left.getY() - i_right.getY(), i_left.getZ() - i_right.getZ());
        return o_result;
    }

    public static Vector3f translate(IVector3f i_source, float x, float y, float z, Vector3f o_result) {
        if (o_result == null) {
            return new Vector3fImpl(x + i_source.getX(), y + i_source.getY(), z + i_source.getZ());
        }
        o_result.set(x + i_source.getX(), y + i_source.getY(), z + i_source.getZ());
        return o_result;
    }

    public static Vector3f IEEERemainder(IVector3f i_source, float divisor, Vector3f o_result) {
        if (o_result == null) {
            o_result = new Vector3fImpl();
        }
        o_result.set((float)Math.IEEEremainder(i_source.getX(), divisor), (float)Math.IEEEremainder(i_source.getY(), divisor), (float)Math.IEEEremainder(i_source.getZ(), divisor));
        return o_result;
    }

    public static String toStringDegree(IVector3f i_rotation) {
        if (i_rotation == null) {
            return "null";
        }
        StringBuilder result = new StringBuilder();
        result.append((int)((double)(i_rotation.getX() * 180.0f) / Math.PI));
        result.append("\ufffd\ufffd/");
        result.append((int)((double)(i_rotation.getY() * 180.0f) / Math.PI));
        result.append("\ufffd\ufffd/");
        result.append((int)((double)(i_rotation.getZ() * 180.0f) / Math.PI));
        result.append("\ufffd\ufffd");
        return result.toString();
    }
}

